/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.keyvalue.core.IdentifierGenerator;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

enum DefaultIdentifierGenerator implements IdentifierGenerator
{
    INSTANCE;

    private final AtomicReference<SecureRandom> secureRandom = new AtomicReference<Object>(null);

    @Override
    public <T> T generateIdentifierOfType(TypeInformation<T> identifierType) {
        Class type = identifierType.getType();
        if (ClassUtils.isAssignable(UUID.class, (Class)type)) {
            return (T)UUID.randomUUID();
        }
        if (ClassUtils.isAssignable(String.class, (Class)type)) {
            return (T)UUID.randomUUID().toString();
        }
        if (ClassUtils.isAssignable(Integer.class, (Class)type)) {
            return (T)Integer.valueOf(this.getSecureRandom().nextInt());
        }
        if (ClassUtils.isAssignable(Long.class, (Class)type)) {
            return (T)Long.valueOf(this.getSecureRandom().nextLong());
        }
        throw new InvalidDataAccessApiUsageException("Non gereratable id type....");
    }

    private SecureRandom getSecureRandom() {
        SecureRandom secureRandom = this.secureRandom.get();
        if (secureRandom != null) {
            return secureRandom;
        }
        for (String algorithm : OsTools.secureRandomAlgorithmNames()) {
            try {
                secureRandom = SecureRandom.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        if (secureRandom == null) {
            throw new InvalidDataAccessApiUsageException(String.format("Could not create SecureRandom instance for one of the algorithms '%s'.", StringUtils.collectionToCommaDelimitedString(OsTools.secureRandomAlgorithmNames())));
        }
        this.secureRandom.compareAndSet(null, secureRandom);
        return secureRandom;
    }

    private static class OsTools {
        private static final String OPERATING_SYSTEM_NAME = System.getProperty("os.name").toLowerCase();
        private static final List<String> SECURE_RANDOM_ALGORITHMS_LINUX_OSX_SOLARIS = Arrays.asList("NativePRNGBlocking", "NativePRNGNonBlocking", "NativePRNG", "SHA1PRNG");
        private static final List<String> SECURE_RANDOM_ALGORITHMS_WINDOWS = Arrays.asList("SHA1PRNG", "Windows-PRNG");

        private OsTools() {
        }

        static List<String> secureRandomAlgorithmNames() {
            return OPERATING_SYSTEM_NAME.contains("win") ? SECURE_RANDOM_ALGORITHMS_WINDOWS : SECURE_RANDOM_ALGORITHMS_LINUX_OSX_SOLARIS;
        }
    }
}

