/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.QueryHint;
import javax.persistence.TypedQuery;
import org.springframework.data.jpa.repository.query.Jpa21Utils;
import org.springframework.data.jpa.repository.query.JpaEntityGraph;
import org.springframework.data.jpa.repository.query.JpaQueryExecution;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.util.Assert;

public abstract class AbstractJpaQuery
implements RepositoryQuery {
    private final JpaQueryMethod method;
    private final EntityManager em;

    public AbstractJpaQuery(JpaQueryMethod method, EntityManager em) {
        Assert.notNull((Object)((Object)method));
        Assert.notNull((Object)em);
        this.method = method;
        this.em = em;
    }

    public JpaQueryMethod getQueryMethod() {
        return this.method;
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public Object execute(Object[] parameters) {
        return this.doExecute(this.getExecution(), parameters);
    }

    private Object doExecute(JpaQueryExecution execution, Object[] values) {
        return execution.execute(this, values);
    }

    protected JpaQueryExecution getExecution() {
        if (this.method.isProcedureQuery()) {
            return new JpaQueryExecution.ProcedureExecution();
        }
        if (this.method.isCollectionQuery()) {
            return new JpaQueryExecution.CollectionExecution();
        }
        if (this.method.isSliceQuery()) {
            return new JpaQueryExecution.SlicedExecution(this.method.getParameters());
        }
        if (this.method.isPageQuery()) {
            return new JpaQueryExecution.PagedExecution(this.method.getParameters());
        }
        if (this.method.isModifyingQuery()) {
            return this.method.getClearAutomatically() ? new JpaQueryExecution.ModifyingExecution(this.method, this.em) : new JpaQueryExecution.ModifyingExecution(this.method, null);
        }
        return new JpaQueryExecution.SingleEntityExecution();
    }

    protected <T extends Query> T applyHints(T query, JpaQueryMethod method) {
        for (QueryHint hint : method.getHints()) {
            this.applyQueryHint(query, hint);
        }
        return query;
    }

    protected <T extends Query> void applyQueryHint(T query, QueryHint hint) {
        Assert.notNull(query, (String)"Query must not be null!");
        Assert.notNull((Object)hint, (String)"QueryHint must not be null!");
        query.setHint(hint.name(), (Object)hint.value());
    }

    private Query applyLockMode(Query query, JpaQueryMethod method) {
        LockModeType lockModeType = method.getLockModeType();
        return lockModeType == null ? query : query.setLockMode(lockModeType);
    }

    protected ParameterBinder createBinder(Object[] values) {
        return new ParameterBinder(this.getQueryMethod().getParameters(), values);
    }

    protected Query createQuery(Object[] values) {
        return this.applyLockMode(this.applyEntityGraphConfiguration(this.applyHints(this.doCreateQuery(values), this.method), this.method), this.method);
    }

    private Query applyEntityGraphConfiguration(Query query, JpaQueryMethod method) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull((Object)((Object)method), (String)"JpaQueryMethod must not be null!");
        JpaEntityGraph entityGraph = method.getEntityGraph();
        if (entityGraph != null) {
            Jpa21Utils.tryConfigureFetchGraph(this.em, query, entityGraph);
        }
        return query;
    }

    protected TypedQuery<Long> createCountQuery(Object[] values) {
        TypedQuery<Long> countQuery = this.doCreateCountQuery(values);
        return this.method.applyHintsToCountQuery() ? this.applyHints((Query)countQuery, this.method) : countQuery;
    }

    protected abstract Query doCreateQuery(Object[] var1);

    protected abstract TypedQuery<Long> doCreateCountQuery(Object[] var1);
}

