/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import com.mysema.query.jpa.EclipseLinkTemplates;
import com.mysema.query.jpa.HQLTemplates;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.JPQLTemplates;
import com.mysema.query.jpa.OpenJPATemplates;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Order;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.path.PathBuilder;
import javax.persistence.EntityManager;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.support.PersistenceProvider;
import org.springframework.util.Assert;

public class Querydsl {
    private final EntityManager em;
    private final PersistenceProvider provider;
    private final PathBuilder<?> builder;

    public Querydsl(EntityManager em, PathBuilder<?> builder) {
        Assert.notNull((Object)em);
        Assert.notNull(builder);
        this.em = em;
        this.provider = PersistenceProvider.fromEntityManager(em);
        this.builder = builder;
    }

    public JPQLQuery createQuery() {
        switch (this.provider) {
            case ECLIPSELINK: {
                return new JPAQuery(this.em, EclipseLinkTemplates.DEFAULT);
            }
            case HIBERNATE: {
                return new JPAQuery(this.em, (JPQLTemplates)HQLTemplates.DEFAULT);
            }
            case OPEN_JPA: {
                return new JPAQuery(this.em, OpenJPATemplates.DEFAULT);
            }
        }
        return new JPAQuery(this.em);
    }

    public JPQLQuery createQuery(EntityPath<?> ... paths) {
        return (JPQLQuery)this.createQuery().from(paths);
    }

    public JPQLQuery applyPagination(Pageable pageable, JPQLQuery query) {
        if (pageable == null) {
            return query;
        }
        query.offset((long)pageable.getOffset());
        query.limit((long)pageable.getPageSize());
        return this.applySorting(pageable.getSort(), query);
    }

    public JPQLQuery applySorting(Sort sort, JPQLQuery query) {
        if (sort == null) {
            return query;
        }
        for (Sort.Order order : sort) {
            query.orderBy(new OrderSpecifier[]{this.toOrder(order)});
        }
        return query;
    }

    private OrderSpecifier<?> toOrder(Sort.Order order) {
        PathBuilder property = this.builder.get(order.getProperty());
        if (order.isIgnoreCase()) {
            property = this.builder.getString(order.getProperty()).lower();
        }
        return new OrderSpecifier(order.isAscending() ? Order.ASC : Order.DESC, (Expression)property);
    }
}

