/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.Tuple;
import javax.persistence.metamodel.ManagedType;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.ExpressionBasedStringQuery;
import org.springframework.data.jpa.repository.query.JpaEntityMetadata;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.jpa.repository.query.SpelExpressionStringQueryParameterBinder;
import org.springframework.data.jpa.repository.query.StringQuery;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

abstract class AbstractStringBasedJpaQuery
extends AbstractJpaQuery {
    private final StringQuery query;
    private final StringQuery countQuery;
    private final EvaluationContextProvider evaluationContextProvider;
    private final SpelExpressionParser parser;

    public AbstractStringBasedJpaQuery(JpaQueryMethod method, EntityManager em, String queryString, EvaluationContextProvider evaluationContextProvider, SpelExpressionParser parser) {
        super(method, em);
        Assert.hasText((String)queryString, (String)"Query string must not be null or empty!");
        Assert.notNull((Object)evaluationContextProvider, (String)"ExpressionEvaluationContextProvider must not be null!");
        Assert.notNull((Object)parser, (String)"Parser must not be null or empty!");
        this.evaluationContextProvider = evaluationContextProvider;
        this.query = new ExpressionBasedStringQuery(queryString, (JpaEntityMetadata<?>)method.getEntityInformation(), parser);
        this.countQuery = new StringQuery(method.getCountQuery() != null ? method.getCountQuery() : QueryUtils.createCountQueryFor(this.query.getQueryString(), method.getCountQueryProjection()));
        this.parser = parser;
    }

    @Override
    public Query doCreateQuery(Object[] values) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor((Parameters)this.getQueryMethod().getParameters(), values);
        String sortedQueryString = QueryUtils.applySorting(this.query.getQueryString(), accessor.getSort(), this.query.getAlias());
        Query query = this.createJpaQuery(sortedQueryString);
        return this.createBinder(values).bindAndPrepare(query);
    }

    @Override
    protected ParameterBinder createBinder(Object[] values) {
        return new SpelExpressionStringQueryParameterBinder(this.getQueryMethod().getParameters(), values, this.query, this.evaluationContextProvider, this.parser);
    }

    @Override
    protected Query doCreateCountQuery(Object[] values) {
        String queryString = this.countQuery.getQueryString();
        EntityManager em = this.getEntityManager();
        return this.createBinder(values).bind(this.getQueryMethod().isNativeQuery() ? em.createNativeQuery(queryString) : em.createQuery(queryString, Long.class));
    }

    public StringQuery getQuery() {
        return this.query;
    }

    public StringQuery getCountQuery() {
        return this.countQuery;
    }

    protected Query createJpaQuery(String queryString) {
        EntityManager em = this.getEntityManager();
        if (this.query.hasConstructorExpression() || this.query.isDefaultProjection()) {
            return em.createQuery(queryString);
        }
        ResultProcessor resultFactory = this.getQueryMethod().getResultProcessor();
        ReturnedType returnedType = resultFactory.getReturnedType();
        return returnedType.isProjecting() && !AbstractStringBasedJpaQuery.isJpaManaged(returnedType.getReturnedType(), em) ? em.createQuery(queryString, Tuple.class) : em.createQuery(queryString);
    }

    private static boolean isJpaManaged(Class<?> type, EntityManager em) {
        for (ManagedType managedType : em.getMetamodel().getManagedTypes()) {
            if (!managedType.getJavaType().equals(type)) continue;
            return true;
        }
        return false;
    }
}

