/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.impl.AbstractJPAQuery;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.support.CrudMethodMetadata;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.Querydsl;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.QSort;
import org.springframework.data.querydsl.QueryDslPredicateExecutor;
import org.springframework.data.querydsl.SimpleEntityPathResolver;

public class QueryDslJpaRepository<T, ID extends Serializable>
extends SimpleJpaRepository<T, ID>
implements QueryDslPredicateExecutor<T> {
    private static final EntityPathResolver DEFAULT_ENTITY_PATH_RESOLVER = SimpleEntityPathResolver.INSTANCE;
    private final EntityPath<T> path;
    private final PathBuilder<T> builder;
    private final Querydsl querydsl;

    public QueryDslJpaRepository(JpaEntityInformation<T, ID> entityInformation, EntityManager entityManager) {
        this(entityInformation, entityManager, DEFAULT_ENTITY_PATH_RESOLVER);
    }

    public QueryDslJpaRepository(JpaEntityInformation<T, ID> entityInformation, EntityManager entityManager, EntityPathResolver resolver) {
        super(entityInformation, entityManager);
        this.path = resolver.createPath(entityInformation.getJavaType());
        this.builder = new PathBuilder(this.path.getType(), this.path.getMetadata());
        this.querydsl = new Querydsl(entityManager, this.builder);
    }

    @Override
    public T findOne(Predicate predicate) {
        return (T)this.createQuery(predicate).select(this.path).fetchOne();
    }

    public List<T> findAll(Predicate predicate) {
        return this.createQuery(predicate).select(this.path).fetch();
    }

    public List<T> findAll(Predicate predicate, OrderSpecifier<?> ... orders) {
        return this.executeSorted(this.createQuery(predicate).select(this.path), orders);
    }

    public List<T> findAll(Predicate predicate, Sort sort) {
        return this.executeSorted(this.createQuery(predicate).select(this.path), sort);
    }

    public List<T> findAll(OrderSpecifier<?> ... orders) {
        return this.executeSorted(this.createQuery(new Predicate[0]).select(this.path), orders);
    }

    public Page<T> findAll(Predicate predicate, Pageable pageable) {
        JPQLQuery<?> countQuery = this.createCountQuery(predicate);
        JPQLQuery query = this.querydsl.applyPagination(pageable, this.createQuery(predicate).select(this.path));
        long total = countQuery.fetchCount();
        List content = pageable == null || total > (long)pageable.getOffset() ? query.fetch() : Collections.emptyList();
        return new PageImpl(content, pageable, total);
    }

    public long count(Predicate predicate) {
        return this.createQuery(predicate).fetchCount();
    }

    @Override
    public boolean exists(Predicate predicate) {
        return this.createQuery(predicate).fetchCount() > 0L;
    }

    protected JPQLQuery<?> createQuery(Predicate ... predicate) {
        AbstractJPAQuery query = (AbstractJPAQuery)this.querydsl.createQuery(this.path).where(predicate);
        CrudMethodMetadata metadata = this.getRepositoryMethodMetadata();
        if (metadata == null) {
            return query;
        }
        LockModeType type = metadata.getLockModeType();
        query = type == null ? query : query.setLockMode(type);
        for (Map.Entry<String, Object> hint : this.getQueryHints().entrySet()) {
            query.setHint(hint.getKey(), hint.getValue());
        }
        return query;
    }

    protected JPQLQuery<?> createCountQuery(Predicate predicate) {
        AbstractJPAQuery query = (AbstractJPAQuery)this.querydsl.createQuery(this.path).where(predicate);
        CrudMethodMetadata metadata = this.getRepositoryMethodMetadata();
        if (metadata == null) {
            return query;
        }
        for (Map.Entry<String, Object> hint : metadata.getQueryHints().entrySet()) {
            query.setHint(hint.getKey(), hint.getValue());
        }
        return query;
    }

    private List<T> executeSorted(JPQLQuery<T> query, OrderSpecifier<?> ... orders) {
        return this.executeSorted(query, (Sort)new QSort(orders));
    }

    private List<T> executeSorted(JPQLQuery<T> query, Sort sort) {
        return this.querydsl.applySorting(sort, query).fetch();
    }
}

