/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.RepositoryQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SimpleJpaQuery
extends AbstractJpaQuery {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleJpaQuery.class);
    private final String queryString;
    private final String countQuery;
    private final String alias;
    private final JpaQueryMethod method;

    SimpleJpaQuery(JpaQueryMethod method, EntityManager em, String queryString) {
        super(method, em);
        boolean hasPagingOrSortingParameter;
        this.queryString = queryString;
        this.alias = QueryUtils.detectAlias(queryString);
        this.countQuery = method.getCountQuery() == null ? QueryUtils.createCountQueryFor(queryString) : method.getCountQuery();
        this.method = method;
        Parameters parameters = method.getParameters();
        boolean bl = hasPagingOrSortingParameter = parameters.hasPageableParameter() || parameters.hasSortParameter();
        if (method.isNativeQuery() && hasPagingOrSortingParameter) {
            throw new IllegalStateException("Cannot use native queries with dynamic sorting and/or pagination!");
        }
        if (!method.isNativeQuery()) {
            em.createQuery(queryString);
        }
    }

    SimpleJpaQuery(JpaQueryMethod method, EntityManager em) {
        this(method, em, method.getAnnotatedQuery());
    }

    @Override
    public Query doCreateQuery(Object[] values) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.method.getParameters(), values);
        String sortedQueryString = QueryUtils.applySorting(this.queryString, accessor.getSort(), this.alias);
        EntityManager em = this.getEntityManager();
        Query query = null;
        query = this.method.isNativeQuery() ? (this.method.isQueryForEntity() ? em.createNativeQuery(sortedQueryString, this.method.getReturnedObjectType()) : em.createNativeQuery(sortedQueryString)) : em.createQuery(sortedQueryString);
        return this.createBinder(values).bindAndPrepare(query);
    }

    @Override
    protected TypedQuery<Long> doCreateCountQuery(Object[] values) {
        return this.createBinder(values).bind(this.getEntityManager().createQuery(this.countQuery, Long.class));
    }

    public static RepositoryQuery fromQueryAnnotation(JpaQueryMethod queryMethod, EntityManager em) {
        LOG.debug("Looking up query for method {}", (Object)queryMethod.getName());
        String query = queryMethod.getAnnotatedQuery();
        return query == null ? null : new SimpleJpaQuery(queryMethod, em, query);
    }
}

