/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.LockModeType;
import javax.persistence.QueryHint;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.jpa.repository.query.QueryExtractor;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaQueryMethod
extends QueryMethod {
    private final QueryExtractor extractor;
    private final Method method;

    public JpaQueryMethod(Method method, RepositoryMetadata metadata, QueryExtractor extractor) {
        super(method, metadata);
        Assert.notNull((Object)method, (String)"Method must not be null!");
        Assert.notNull((Object)extractor, (String)"Query extractor must not be null!");
        this.method = method;
        this.extractor = extractor;
        Assert.isTrue((!this.isModifyingQuery() || !this.getParameters().hasSpecialParameter() ? 1 : 0) != 0, (String)String.format("Modifying method must not contain %s!", Parameters.TYPES));
        this.assertParameterNamesInAnnotatedQuery();
    }

    private void assertParameterNamesInAnnotatedQuery() {
        String annotatedQuery = this.getAnnotatedQuery();
        if (!StringUtils.hasText((String)annotatedQuery)) {
            return;
        }
        for (Parameter parameter : this.getParameters()) {
            if (!parameter.isNamedParameter()) continue;
            if (annotatedQuery.contains(String.format(":%s", parameter.getName()))) continue;
            throw new IllegalStateException(String.format("Using named parameters for method %s but parameter '%s' not found in annotated query '%s'!", this.method, parameter.getName(), annotatedQuery));
        }
    }

    public boolean isModifyingQuery() {
        return null != this.method.getAnnotation(Modifying.class);
    }

    List<QueryHint> getHints() {
        ArrayList<QueryHint> result = new ArrayList<QueryHint>();
        QueryHints hints = (QueryHints)AnnotationUtils.getAnnotation((Method)this.method, QueryHints.class);
        if (hints != null) {
            result.addAll(Arrays.asList(hints.value()));
        }
        return result;
    }

    LockModeType getLockModeType() {
        Lock annotation = this.method.getAnnotation(Lock.class);
        return (LockModeType)AnnotationUtils.getValue((Annotation)annotation);
    }

    boolean applyHintsToCountQuery() {
        QueryHints hints = (QueryHints)AnnotationUtils.getAnnotation((Method)this.method, QueryHints.class);
        return hints != null ? hints.forCounting() : false;
    }

    QueryExtractor getQueryExtractor() {
        return this.extractor;
    }

    Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    String getAnnotatedQuery() {
        String query = this.getAnnotationValue("value", String.class);
        return StringUtils.hasText((String)query) ? query : null;
    }

    String getCountQuery() {
        String countQuery = this.getAnnotationValue("countQuery", String.class);
        return StringUtils.hasText((String)countQuery) ? countQuery : null;
    }

    boolean isNativeQuery() {
        return this.getAnnotationValue("nativeQuery", Boolean.class);
    }

    public String getNamedQueryName() {
        String annotatedName = this.getAnnotationValue("name", String.class);
        return StringUtils.hasText((String)annotatedName) ? annotatedName : super.getNamedQueryName();
    }

    String getNamedCountQueryName() {
        String annotatedName = this.getAnnotationValue("countName", String.class);
        return StringUtils.hasText((String)annotatedName) ? annotatedName : this.getNamedQueryName() + ".count";
    }

    boolean getClearAutomatically() {
        return (Boolean)AnnotationUtils.getValue((Annotation)this.method.getAnnotation(Modifying.class), (String)"clearAutomatically");
    }

    private <T> T getAnnotationValue(String attribute, Class<T> type) {
        Query annotation = this.method.getAnnotation(Query.class);
        Object value = annotation == null ? AnnotationUtils.getDefaultValue(Query.class, (String)attribute) : AnnotationUtils.getValue((Annotation)annotation, (String)attribute);
        return type.cast(value);
    }
}

