/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.config;

import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.aop.target.LazyInitTargetSource;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class AuditingBeanDefinitionParser
implements BeanDefinitionParser {
    static final String AUDITING_ENTITY_LISTENER_CLASS_NAME = "org.springframework.data.jpa.domain.support.AuditingEntityListener";
    private static final String AUDITING_BFPP_CLASS_NAME = "org.springframework.data.jpa.domain.support.AuditingBeanFactoryPostProcessor";

    public BeanDefinition parse(Element element, ParserContext parser) {
        new SpringConfiguredBeanDefinitionParser().parse(element, parser);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)AUDITING_ENTITY_LISTENER_CLASS_NAME);
        builder.setScope("prototype");
        String auditorAwareRef = element.getAttribute("auditor-aware-ref");
        if (StringUtils.hasText((String)auditorAwareRef)) {
            builder.addPropertyValue("auditorAware", (Object)this.createLazyInitTargetSourceBeanDefinition(auditorAwareRef));
        }
        builder.addPropertyValue("dateTimeForNow", (Object)element.getAttribute("set-dates"));
        String dateTimeProviderRef = element.getAttribute("date-time-provider-ref");
        if (StringUtils.hasText((String)dateTimeProviderRef)) {
            builder.addPropertyReference("dateTimeProvider", dateTimeProviderRef);
        }
        this.registerInfrastructureBeanWithId(builder.getRawBeanDefinition(), AUDITING_ENTITY_LISTENER_CLASS_NAME, parser, element);
        RootBeanDefinition def = new RootBeanDefinition();
        def.setBeanClassName(AUDITING_BFPP_CLASS_NAME);
        this.registerInfrastructureBeanWithId((AbstractBeanDefinition)def, AUDITING_BFPP_CLASS_NAME, parser, element);
        return null;
    }

    private BeanDefinition createLazyInitTargetSourceBeanDefinition(String auditorAwareRef) {
        BeanDefinitionBuilder targetSourceBuilder = BeanDefinitionBuilder.rootBeanDefinition(LazyInitTargetSource.class);
        targetSourceBuilder.addPropertyValue("targetBeanName", (Object)auditorAwareRef);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ProxyFactoryBean.class);
        builder.addPropertyValue("targetSource", (Object)targetSourceBuilder.getBeanDefinition());
        return builder.getBeanDefinition();
    }

    private void registerInfrastructureBeanWithId(AbstractBeanDefinition def, String id, ParserContext context, Element element) {
        def.setRole(2);
        def.setSource(context.extractSource((Object)element));
        context.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)def, id));
    }

    private static class SpringConfiguredBeanDefinitionParser
    implements BeanDefinitionParser {
        private static final String BEAN_CONFIGURER_ASPECT_BEAN_NAME = "org.springframework.context.config.internalBeanConfigurerAspect";
        private static final String BEAN_CONFIGURER_ASPECT_CLASS_NAME = "org.springframework.beans.factory.aspectj.AnnotationBeanConfigurerAspect";

        private SpringConfiguredBeanDefinitionParser() {
        }

        public BeanDefinition parse(Element element, ParserContext parserContext) {
            if (!parserContext.getRegistry().containsBeanDefinition(BEAN_CONFIGURER_ASPECT_BEAN_NAME)) {
                RootBeanDefinition def = new RootBeanDefinition();
                def.setBeanClassName(BEAN_CONFIGURER_ASPECT_CLASS_NAME);
                def.setFactoryMethodName("aspectOf");
                def.setRole(2);
                def.setSource(parserContext.extractSource((Object)element));
                parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)def, BEAN_CONFIGURER_ASPECT_BEAN_NAME));
            }
            return null;
        }
    }
}

