/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.conversion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.convert.EntityWriter;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.PersistentPropertyPaths;
import org.springframework.data.relational.core.conversion.AggregateChange;
import org.springframework.data.relational.core.conversion.DbAction;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.util.Pair;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RelationalEntityWriter
implements EntityWriter<Object, AggregateChange<?>> {
    private final RelationalMappingContext context;

    public RelationalEntityWriter(RelationalMappingContext context) {
        this.context = context;
    }

    public void write(Object root, AggregateChange<?> aggregateChange) {
        List actions = new WritingContext(root, aggregateChange).write();
        actions.forEach(aggregateChange::addAction);
    }

    static final class PathNode {
        private final PersistentPropertyPath<RelationalPersistentProperty> path;
        @Nullable
        private final PathNode parent;
        private final Object value;

        public PathNode(PersistentPropertyPath<RelationalPersistentProperty> path, @Nullable PathNode parent, Object value) {
            this.path = path;
            this.parent = parent;
            this.value = value;
        }

        public PersistentPropertyPath<RelationalPersistentProperty> getPath() {
            return this.path;
        }

        @Nullable
        public PathNode getParent() {
            return this.parent;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PathNode)) {
                return false;
            }
            PathNode other = (PathNode)o;
            PersistentPropertyPath<RelationalPersistentProperty> this$path = this.getPath();
            PersistentPropertyPath<RelationalPersistentProperty> other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            PathNode this$parent = this.getParent();
            PathNode other$parent = other.getParent();
            if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PersistentPropertyPath<RelationalPersistentProperty> $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            PathNode $parent = this.getParent();
            result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "RelationalEntityWriter.PathNode(path=" + this.getPath() + ", parent=" + this.getParent() + ", value=" + this.getValue() + ")";
        }
    }

    private class WritingContext {
        private final Object root;
        private final Object entity;
        private final Class<?> entityType;
        private final PersistentPropertyPaths<?, RelationalPersistentProperty> paths;
        private final Map<PathNode, DbAction> previousActions = new HashMap<PathNode, DbAction>();
        private Map<PersistentPropertyPath<RelationalPersistentProperty>, List<PathNode>> nodesCache = new HashMap<PersistentPropertyPath<RelationalPersistentProperty>, List<PathNode>>();

        WritingContext(Object root, AggregateChange<?> aggregateChange) {
            this.root = root;
            this.entity = aggregateChange.getEntity();
            this.entityType = aggregateChange.getEntityType();
            this.paths = RelationalEntityWriter.this.context.findPersistentPropertyPaths(this.entityType, PersistentProperty::isEntity);
        }

        private List<DbAction<?>> write() {
            ArrayList actions = new ArrayList();
            if (this.isNew(this.root)) {
                actions.add(this.setRootAction(new DbAction.InsertRoot<Object>(this.entity)));
                actions.addAll(this.insertReferenced());
            } else {
                actions.addAll(this.deleteReferenced());
                actions.add(this.setRootAction(new DbAction.UpdateRoot<Object>(this.entity)));
                actions.addAll(this.insertReferenced());
            }
            return actions;
        }

        private List<DbAction<?>> insertReferenced() {
            ArrayList actions = new ArrayList();
            this.paths.forEach(path -> actions.addAll(this.insertAll((PersistentPropertyPath<RelationalPersistentProperty>)path)));
            return actions;
        }

        private List<DbAction<?>> insertAll(PersistentPropertyPath<RelationalPersistentProperty> path) {
            ArrayList actions = new ArrayList();
            this.from(path).forEach(node -> {
                DbAction.Insert<Object> insert;
                if (((RelationalPersistentProperty)((PathNode)node).path.getRequiredLeafProperty()).isQualified()) {
                    Pair value = (Pair)node.getValue();
                    insert = new DbAction.Insert<Object>(value.getSecond(), path, this.getAction(((PathNode)node).parent));
                    insert.getAdditionalValues().put(((RelationalPersistentProperty)((PathNode)node).path.getRequiredLeafProperty()).getKeyColumn(), value.getFirst());
                } else {
                    insert = new DbAction.Insert<Object>(node.getValue(), path, this.getAction(((PathNode)node).parent));
                }
                this.previousActions.put((PathNode)node, insert);
                actions.add(insert);
            });
            return actions;
        }

        private List<DbAction<?>> deleteReferenced() {
            ArrayList deletes = new ArrayList();
            this.paths.forEach(path -> deletes.add(0, this.deleteReferenced((PersistentPropertyPath<RelationalPersistentProperty>)path)));
            return deletes;
        }

        private DbAction.Delete<?> deleteReferenced(PersistentPropertyPath<RelationalPersistentProperty> path) {
            Object id = ((RelationalPersistentEntity)RelationalEntityWriter.this.context.getRequiredPersistentEntity(this.entityType)).getIdentifierAccessor(this.entity).getIdentifier();
            return new DbAction.Delete(id, path);
        }

        private DbAction<?> setRootAction(DbAction<?> dbAction) {
            this.previousActions.put(null, dbAction);
            return dbAction;
        }

        @Nullable
        private DbAction.WithEntity<?> getAction(@Nullable PathNode parent) {
            DbAction action = this.previousActions.get(parent);
            if (action != null) {
                Assert.isInstanceOf(DbAction.WithEntity.class, (Object)action, (String)("dependsOn action is not a WithEntity, but " + action.getClass().getSimpleName()));
                return (DbAction.WithEntity)action;
            }
            return null;
        }

        private boolean isNew(Object o) {
            return ((RelationalPersistentEntity)RelationalEntityWriter.this.context.getRequiredPersistentEntity(o.getClass())).isNew(o);
        }

        private List<PathNode> from(PersistentPropertyPath<RelationalPersistentProperty> path) {
            ArrayList<PathNode> nodes = new ArrayList<PathNode>();
            if (path.getLength() == 1) {
                Object value = ((RelationalPersistentEntity)RelationalEntityWriter.this.context.getRequiredPersistentEntity(this.entityType)).getPropertyAccessor(this.entity).getProperty(path.getRequiredLeafProperty());
                nodes.addAll(this.createNodes(path, null, value));
            } else {
                List<PathNode> pathNodes = this.nodesCache.get(path.getParentPath());
                pathNodes.forEach(parentNode -> {
                    Object value = ((RelationalPersistentProperty)path.getRequiredLeafProperty()).getOwner().getPropertyAccessor(parentNode.getValue()).getProperty(path.getRequiredLeafProperty());
                    nodes.addAll(this.createNodes(path, (PathNode)parentNode, value));
                });
            }
            this.nodesCache.put(path, nodes);
            return nodes;
        }

        private List<PathNode> createNodes(PersistentPropertyPath<RelationalPersistentProperty> path, @Nullable PathNode parentNode, @Nullable Object value) {
            if (value == null) {
                return Collections.emptyList();
            }
            ArrayList<PathNode> nodes = new ArrayList<PathNode>();
            if (((RelationalPersistentProperty)path.getRequiredLeafProperty()).isQualified()) {
                if (((RelationalPersistentProperty)path.getRequiredLeafProperty()).isMap()) {
                    ((Map)value).forEach((k, v) -> nodes.add(new PathNode(path, parentNode, Pair.of((Object)k, (Object)v))));
                } else {
                    List listValue = (List)value;
                    for (int k2 = 0; k2 < listValue.size(); ++k2) {
                        nodes.add(new PathNode(path, parentNode, Pair.of((Object)k2, listValue.get(k2))));
                    }
                }
            } else if (((RelationalPersistentProperty)path.getRequiredLeafProperty()).isCollectionLike()) {
                ((Collection)value).forEach(v -> nodes.add(new PathNode(path, parentNode, v)));
            } else {
                nodes.add(new PathNode(path, parentNode, value));
            }
            return nodes;
        }
    }
}

