/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.conversion;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.conversion.DbAction;
import org.springframework.data.relational.core.conversion.Interpreter;
import org.springframework.data.relational.core.conversion.RelationalConverter;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class AggregateChange<T> {
    private final Kind kind;
    private final Class<T> entityType;
    @Nullable
    private T entity;
    private final List<DbAction<?>> actions = new ArrayList();

    public AggregateChange(Kind kind, Class<T> entityType, @Nullable T entity) {
        this.kind = kind;
        this.entityType = entityType;
        this.entity = entity;
    }

    public void executeWith(Interpreter interpreter, RelationalMappingContext context, RelationalConverter converter) {
        RelationalPersistentEntity persistentEntity = this.entity != null ? (RelationalPersistentEntity)context.getRequiredPersistentEntity(this.entity.getClass()) : null;
        PersistentPropertyAccessor<T> propertyAccessor = persistentEntity != null ? converter.getPropertyAccessor(persistentEntity, this.entity) : null;
        this.actions.forEach(a -> {
            a.executeWith(interpreter);
            if (a instanceof DbAction.WithGeneratedId) {
                Assert.notNull((Object)persistentEntity, (String)"For statements triggering database side id generation a RelationalPersistentEntity must be provided.");
                Assert.notNull((Object)propertyAccessor, (String)"propertyAccessor must not be null");
                Object generatedId = ((DbAction.WithGeneratedId)a).getGeneratedId();
                if (generatedId != null) {
                    if (a instanceof DbAction.InsertRoot && a.getEntityType().equals(this.entityType)) {
                        propertyAccessor.setProperty(persistentEntity.getRequiredIdProperty(), generatedId);
                    } else if (a instanceof DbAction.WithDependingOn) {
                        AggregateChange.setId(context, converter, propertyAccessor, (DbAction.WithDependingOn)a, generatedId);
                    }
                }
            }
        });
        if (propertyAccessor != null) {
            this.entity = propertyAccessor.getBean();
        }
    }

    public void addAction(DbAction<?> action) {
        this.actions.add(action);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void setId(RelationalMappingContext context, RelationalConverter converter, PersistentPropertyAccessor<?> propertyAccessor, DbAction.WithDependingOn<?> action, Object generatedId) {
        PersistentPropertyPath<RelationalPersistentProperty> propertyPathToEntity = action.getPropertyPath();
        RelationalPersistentProperty requiredIdProperty = (RelationalPersistentProperty)((RelationalPersistentEntity)context.getRequiredPersistentEntity(((RelationalPersistentProperty)propertyPathToEntity.getRequiredLeafProperty()).getActualType())).getRequiredIdProperty();
        PersistentPropertyPath pathToId = context.getPersistentPropertyPath(propertyPathToEntity.toDotPath() + '.' + requiredIdProperty.getName(), ((RelationalPersistentProperty)propertyPathToEntity.getBaseProperty()).getOwner().getType());
        RelationalPersistentProperty leafProperty = (RelationalPersistentProperty)propertyPathToEntity.getRequiredLeafProperty();
        Object currentPropertyValue = propertyAccessor.getProperty(propertyPathToEntity);
        Assert.notNull((Object)currentPropertyValue, (String)"Trying to set an ID for an element that does not exist");
        if (leafProperty.isQualified()) {
            String keyColumn = leafProperty.getKeyColumn();
            Object keyObject = action.getAdditionalValues().get(keyColumn);
            if (List.class.isAssignableFrom(leafProperty.getType())) {
                AggregateChange.setIdInElementOfList(converter, action, generatedId, (List)currentPropertyValue, (Integer)keyObject);
                return;
            } else {
                if (!Map.class.isAssignableFrom(leafProperty.getType())) throw new IllegalStateException("Can't handle " + currentPropertyValue);
                AggregateChange.setIdInElementOfMap(converter, action, generatedId, (Map)currentPropertyValue, keyObject);
            }
            return;
        } else if (leafProperty.isCollectionLike()) {
            if (!Set.class.isAssignableFrom(leafProperty.getType())) throw new IllegalStateException("Can't handle " + currentPropertyValue);
            AggregateChange.setIdInElementOfSet(converter, action, generatedId, (Set)currentPropertyValue);
            return;
        } else {
            propertyAccessor.setProperty(pathToId, generatedId);
        }
    }

    private static <T> void setIdInElementOfSet(RelationalConverter converter, DbAction.WithDependingOn<?> action, Object generatedId, Set<T> set) {
        PersistentPropertyAccessor<?> intermediateAccessor = AggregateChange.setId(converter, action, generatedId);
        set.remove(action.getEntity());
        set.add(intermediateAccessor.getBean());
    }

    private static <K, V> void setIdInElementOfMap(RelationalConverter converter, DbAction.WithDependingOn<?> action, Object generatedId, Map<K, V> map, K keyObject) {
        PersistentPropertyAccessor<?> intermediateAccessor = AggregateChange.setId(converter, action, generatedId);
        map.put(keyObject, intermediateAccessor.getBean());
    }

    private static <T> void setIdInElementOfList(RelationalConverter converter, DbAction.WithDependingOn<?> action, Object generatedId, List<T> list, int index) {
        PersistentPropertyAccessor<?> intermediateAccessor = AggregateChange.setId(converter, action, generatedId);
        list.set(index, intermediateAccessor.getBean());
    }

    private static <T> PersistentPropertyAccessor<T> setId(RelationalConverter converter, DbAction.WithDependingOn<T> action, Object generatedId) {
        Object originalElement = action.getEntity();
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)converter.getMappingContext().getRequiredPersistentEntity(action.getEntityType());
        PersistentPropertyAccessor intermediateAccessor = converter.getPropertyAccessor(persistentEntity, originalElement);
        intermediateAccessor.setProperty(persistentEntity.getRequiredIdProperty(), generatedId);
        return intermediateAccessor;
    }

    public Kind getKind() {
        return this.kind;
    }

    public Class<T> getEntityType() {
        return this.entityType;
    }

    @Nullable
    public T getEntity() {
        return this.entity;
    }

    public List<DbAction<?>> getActions() {
        return this.actions;
    }

    public static enum Kind {
        SAVE,
        DELETE;

    }
}

