/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.PropertyValues;
import org.springframework.boot.bind.PropertySourcesPropertyValues;
import org.springframework.boot.bind.RelaxedDataBinder;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySources;
import org.springframework.util.Assert;

public class EnvironmentEntryInitializingTreeMap<T>
extends AbstractMap<String, T> {
    private final ConfigurableEnvironment environment;
    private final Class<T> entryClass;
    private final String defaultsPrefix;
    private final Map<String, T> delegate;

    public EnvironmentEntryInitializingTreeMap(ConfigurableEnvironment environment, Class<T> entryClass, String defaultsPrefix, Map<String, T> delegate) {
        Assert.notNull((Object)environment, (String)"The environment cannot be null");
        Assert.notNull(entryClass, (String)"The entry class cannot be null");
        Assert.notNull((Object)defaultsPrefix, (String)"The prefix for the property defaults cannot be null");
        Assert.notNull(delegate, (String)"The delegate cannot be null");
        this.environment = environment;
        this.entryClass = entryClass;
        this.defaultsPrefix = defaultsPrefix;
        this.delegate = delegate;
    }

    @Override
    public T get(Object key) {
        if (!this.delegate.containsKey(key) && key instanceof String) {
            Object entry = BeanUtils.instantiate(this.entryClass);
            RelaxedDataBinder defaultsDataBinder = new RelaxedDataBinder(entry, this.defaultsPrefix);
            defaultsDataBinder.bind((PropertyValues)new PropertySourcesPropertyValues((PropertySources)this.environment.getPropertySources()));
            this.delegate.put((String)key, entry);
        }
        return this.delegate.get(key);
    }

    @Override
    public T put(String key, T value) {
        return this.delegate.put(key, value);
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }
}

