/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.turbine.stream;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.netflix.turbine.stream.HystrixStreamAggregator;
import org.springframework.cloud.netflix.turbine.stream.TurbineStreamClient;
import org.springframework.cloud.netflix.turbine.stream.TurbineStreamProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.config.ChannelBindingServiceProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import rx.subjects.PublishSubject;

@Configuration
@ConditionalOnClass(value={EnableBinding.class})
@ConditionalOnProperty(value={"turbine.stream.enabled"}, matchIfMissing=true)
@EnableBinding(value={TurbineStreamClient.class})
public class TurbineStreamAutoConfiguration {
    @Autowired
    private ChannelBindingServiceProperties bindings;
    @Autowired
    private TurbineStreamProperties properties;

    @PostConstruct
    public void init() {
        BindingProperties input;
        BindingProperties inputBinding = (BindingProperties)this.bindings.getBindings().get("turbineStreamInput");
        if (inputBinding == null) {
            this.bindings.getBindings().put("turbineStreamInput", new BindingProperties());
        }
        if ((input = (BindingProperties)this.bindings.getBindings().get("turbineStreamInput")).getDestination() == null) {
            input.setDestination(this.properties.getDestination());
        }
        if (input.getContentType() == null) {
            input.setContentType(this.properties.getContentType());
        }
    }

    @Bean
    public HystrixStreamAggregator hystrixStreamAggregator(ObjectMapper mapper, PublishSubject<Map<String, Object>> publisher) {
        return new HystrixStreamAggregator(mapper, publisher);
    }
}

