/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.turbine.stream;

import java.util.HashMap;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class TurbinePortApplicationListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent> {
    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        Integer serverPort = (Integer)event.getEnvironment().getProperty("server.port", Integer.class);
        Integer managementPort = (Integer)event.getEnvironment().getProperty("management.port", Integer.class);
        Integer turbinePort = (Integer)event.getEnvironment().getProperty("turbine.stream.port", Integer.class);
        if (serverPort == null && managementPort == null) {
            return;
        }
        if (serverPort != Integer.valueOf(-1)) {
            HashMap<String, Integer> ports = new HashMap<String, Integer>();
            if (turbinePort == null) {
                ports.put("server.port", -1);
                if (serverPort != null) {
                    ports.put("turbine.stream.port", serverPort);
                }
            } else if (managementPort != null && managementPort != -1 && serverPort == null) {
                ports.put("server.port", managementPort);
            }
            event.getEnvironment().getPropertySources().addFirst((PropertySource)new MapPropertySource("ports", ports));
        }
    }
}

