/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon.okhttp;

import com.google.common.reflect.TypeToken;
import com.netflix.client.ClientException;
import com.netflix.client.http.CaseInsensitiveMultiMap;
import com.netflix.client.http.HttpHeaders;
import com.netflix.client.http.HttpResponse;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.springframework.util.Assert;

public class OkHttpRibbonResponse
implements HttpResponse {
    private final ResponseBody body;
    private URI uri;
    private Response response;

    public OkHttpRibbonResponse(Response response, URI uri) {
        Assert.notNull((Object)response, (String)"response can not be null");
        this.response = response;
        this.body = response.body();
        this.uri = uri;
    }

    public int getStatus() {
        return this.response.code();
    }

    public String getStatusLine() {
        return this.response.message();
    }

    public Object getPayload() throws ClientException {
        if (!this.hasPayload()) {
            return null;
        }
        return this.body.byteStream();
    }

    public boolean hasPayload() {
        return this.body != null;
    }

    public boolean isSuccess() {
        return this.response.isSuccessful();
    }

    public URI getRequestedURI() {
        return this.uri;
    }

    public Map<String, Collection<String>> getHeaders() {
        HashMap<String, Collection<String>> headers = new HashMap<String, Collection<String>>();
        for (Map.Entry entry : this.response.headers().toMultimap().entrySet()) {
            String name = (String)entry.getKey();
            for (String value : (List)entry.getValue()) {
                if (headers.containsKey(name)) {
                    ((Collection)headers.get(name)).add(value);
                    continue;
                }
                ArrayList<String> values = new ArrayList<String>();
                values.add(value);
                headers.put(name, values);
            }
        }
        return headers;
    }

    public HttpHeaders getHttpHeaders() {
        CaseInsensitiveMultiMap headers = new CaseInsensitiveMultiMap();
        for (Map.Entry entry : this.response.headers().toMultimap().entrySet()) {
            for (String value : (List)entry.getValue()) {
                headers.addHeader((String)entry.getKey(), value);
            }
        }
        return headers;
    }

    public void close() {
        this.response.close();
    }

    public InputStream getInputStream() {
        if (this.body == null) {
            return null;
        }
        return this.body.byteStream();
    }

    public boolean hasEntity() {
        return this.hasPayload();
    }

    public <T> T getEntity(Class<T> type) throws Exception {
        return null;
    }

    public <T> T getEntity(Type type) throws Exception {
        return null;
    }

    public <T> T getEntity(TypeToken<T> type) throws Exception {
        return null;
    }
}

