/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.HealthCheckHandler;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.OrderedHealthAggregator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.cloud.netflix.eureka.CloudEurekaInstanceConfig;
import org.springframework.cloud.netflix.eureka.EurekaHealthCheckHandler;
import org.springframework.cloud.netflix.eureka.EurekaHealthIndicator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.Ordered;

@Configuration
@EnableConfigurationProperties
@ConditionalOnClass(value={EurekaClientConfig.class})
@ConditionalOnProperty(value={"eureka.client.enabled"}, matchIfMissing=true)
public class EurekaDiscoveryClientConfiguration
implements SmartLifecycle,
Ordered {
    private static final Log log = LogFactory.getLog(EurekaDiscoveryClientConfiguration.class);
    private AtomicBoolean running = new AtomicBoolean(false);
    private int order = 0;
    private AtomicInteger port = new AtomicInteger(0);
    @Autowired
    private CloudEurekaInstanceConfig instanceConfig;
    @Autowired(required=false)
    private HealthCheckHandler healthCheckHandler;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private ApplicationInfoManager applicationInfoManager;
    @Autowired
    private EurekaClient eurekaClient;

    public void start() {
        if (this.port.get() != 0 && this.instanceConfig.getNonSecurePort() == 0) {
            this.instanceConfig.setNonSecurePort(this.port.get());
        }
        if (!this.running.get() && this.instanceConfig.getNonSecurePort() > 0) {
            this.maybeInitializeClient();
            if (log.isInfoEnabled()) {
                log.info((Object)("Registering application " + this.instanceConfig.getAppname() + " with eureka with status " + this.instanceConfig.getInitialStatus()));
            }
            this.applicationInfoManager.setInstanceStatus(this.instanceConfig.getInitialStatus());
            if (this.healthCheckHandler != null) {
                this.eurekaClient.registerHealthCheck(this.healthCheckHandler);
            }
            this.context.publishEvent((ApplicationEvent)new InstanceRegisteredEvent((Object)this, (Object)this.instanceConfig));
            this.running.set(true);
        }
    }

    private void maybeInitializeClient() {
        this.applicationInfoManager.getInfo();
        this.eurekaClient.getApplications();
    }

    public void stop() {
        if (this.applicationInfoManager.getInfo() != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Unregistering application " + this.instanceConfig.getAppname() + " with eureka with status DOWN"));
            }
            this.applicationInfoManager.setInstanceStatus(InstanceInfo.InstanceStatus.DOWN);
        }
        this.running.set(false);
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public int getPhase() {
        return 0;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public int getOrder() {
        return this.order;
    }

    @EventListener(value={EmbeddedServletContainerInitializedEvent.class})
    public void onApplicationEvent(EmbeddedServletContainerInitializedEvent event) {
        int localPort = event.getEmbeddedServletContainer().getPort();
        if (this.port.get() == 0) {
            log.info((Object)("Updating port to " + localPort));
            this.port.compareAndSet(0, localPort);
            this.start();
        }
    }

    @EventListener(value={ContextClosedEvent.class})
    public void onApplicationEvent(ContextClosedEvent event) {
        this.stop();
        this.eurekaClient.shutdown();
    }

    @Configuration
    @ConditionalOnProperty(value={"eureka.client.healthcheck.enabled"}, matchIfMissing=false)
    @ConditionalOnBean(value={HealthIndicator.class})
    protected static class EurekaHealthCheckHandlerConfiguration {
        @Autowired(required=false)
        private HealthAggregator healthAggregator = new OrderedHealthAggregator();

        protected EurekaHealthCheckHandlerConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={HealthCheckHandler.class})
        public EurekaHealthCheckHandler eurekaHealthCheckHandler() {
            return new EurekaHealthCheckHandler(this.healthAggregator);
        }
    }

    @Configuration
    @ConditionalOnClass(value={Endpoint.class})
    protected static class EurekaHealthIndicatorConfiguration {
        protected EurekaHealthIndicatorConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public EurekaHealthIndicator eurekaHealthIndicator(EurekaClient eurekaClient, EurekaInstanceConfig instanceConfig, EurekaClientConfig clientConfig) {
            return new EurekaHealthIndicator(eurekaClient, instanceConfig, clientConfig);
        }
    }

    @Configuration
    @ConditionalOnClass(value={RefreshScopeRefreshedEvent.class})
    protected static class EurekaClientConfigurationRefresher {
        @Autowired
        private EurekaDiscoveryClientConfiguration clientConfig;

        protected EurekaClientConfigurationRefresher() {
        }

        @EventListener(value={RefreshScopeRefreshedEvent.class})
        public void onApplicationEvent(RefreshScopeRefreshedEvent event) {
            this.clientConfig.stop();
            this.clientConfig.start();
        }
    }
}

