/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.context.named;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration;
import org.springframework.cloud.context.named.ClientFactoryObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public abstract class NamedContextFactory<C extends Specification>
implements DisposableBean,
ApplicationContextAware {
    private final String propertySourceName;
    private final String propertyName;
    private Map<String, AnnotationConfigApplicationContext> contexts = new ConcurrentHashMap<String, AnnotationConfigApplicationContext>();
    private Map<String, C> configurations = new ConcurrentHashMap<String, C>();
    private ApplicationContext parent;
    private Class<?> defaultConfigType;

    public NamedContextFactory(Class<?> defaultConfigType, String propertySourceName, String propertyName) {
        this.defaultConfigType = defaultConfigType;
        this.propertySourceName = propertySourceName;
        this.propertyName = propertyName;
    }

    public void setApplicationContext(ApplicationContext parent) throws BeansException {
        this.parent = parent;
    }

    public void setConfigurations(List<C> configurations) {
        for (Specification client : configurations) {
            this.configurations.put(client.getName(), client);
        }
    }

    public Set<String> getContextNames() {
        return new HashSet<String>(this.contexts.keySet());
    }

    public void destroy() {
        Collection<AnnotationConfigApplicationContext> values = this.contexts.values();
        for (AnnotationConfigApplicationContext context : values) {
            context.close();
        }
        this.contexts.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AnnotationConfigApplicationContext getContext(String name) {
        if (!this.contexts.containsKey(name)) {
            Map<String, AnnotationConfigApplicationContext> map = this.contexts;
            synchronized (map) {
                if (!this.contexts.containsKey(name)) {
                    this.contexts.put(name, this.createContext(name));
                }
            }
        }
        return this.contexts.get(name);
    }

    protected AnnotationConfigApplicationContext createContext(String name) {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        if (this.configurations.containsKey(name)) {
            for (Class<?> configuration : ((Specification)this.configurations.get(name)).getConfiguration()) {
                context.register(new Class[]{configuration});
            }
        }
        for (Map.Entry entry : this.configurations.entrySet()) {
            if (!((String)entry.getKey()).startsWith("default.")) continue;
            for (Class<?> configuration : ((Specification)entry.getValue()).getConfiguration()) {
                context.register(new Class[]{configuration});
            }
        }
        context.register(new Class[]{PropertyPlaceholderAutoConfiguration.class, this.defaultConfigType});
        context.getEnvironment().getPropertySources().addFirst((PropertySource)new MapPropertySource(this.propertySourceName, Collections.singletonMap(this.propertyName, name)));
        if (this.parent != null) {
            context.setParent(this.parent);
            context.setClassLoader(this.parent.getClassLoader());
        }
        context.setDisplayName(this.generateDisplayName(name));
        context.refresh();
        return context;
    }

    protected String generateDisplayName(String name) {
        return this.getClass().getSimpleName() + "-" + name;
    }

    public <T> T getInstance(String name, Class<T> type) {
        AnnotationConfigApplicationContext context = this.getContext(name);
        if (BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)context, type).length > 0) {
            return (T)context.getBean(type);
        }
        return null;
    }

    public <T> ObjectProvider<T> getLazyProvider(String name, Class<T> type) {
        return new ClientFactoryObjectProvider<T>(this, name, type);
    }

    public <T> ObjectProvider<T> getProvider(String name, Class<T> type) {
        AnnotationConfigApplicationContext context = this.getContext(name);
        return context.getBeanProvider(type);
    }

    public <T> T getInstance(String name, Class<?> clazz, Class<?> ... generics) {
        ResolvableType type = ResolvableType.forClassWithGenerics(clazz, (Class[])generics);
        return this.getInstance(name, type);
    }

    public <T> T getInstance(String name, ResolvableType type) {
        AnnotationConfigApplicationContext context = this.getContext(name);
        String[] beanNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)context, (ResolvableType)type);
        if (beanNames.length > 0) {
            for (String beanName : beanNames) {
                if (!context.isTypeMatch(beanName, type)) continue;
                return (T)context.getBean(beanName);
            }
        }
        return null;
    }

    public <T> Map<String, T> getInstances(String name, Class<T> type) {
        AnnotationConfigApplicationContext context = this.getContext(name);
        if (BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)context, type).length > 0) {
            return BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, type);
        }
        return null;
    }

    public static interface Specification {
        public String getName();

        public Class<?>[] getConfiguration();
    }
}

