/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.context.properties;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.context.properties.ConfigurationBeanFactoryMetaData;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindingPostProcessor;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.stereotype.Component;

@Component
@ManagedResource
public class ConfigurationPropertiesRebinder
implements BeanPostProcessor,
ApplicationListener<EnvironmentChangeEvent>,
ApplicationContextAware {
    private ConfigurationBeanFactoryMetaData metaData;
    private ConfigurationPropertiesBindingPostProcessor binder;
    private Map<String, Object> beans = new HashMap<String, Object>();
    private ApplicationContext applicationContext;

    public ConfigurationPropertiesRebinder(ConfigurationPropertiesBindingPostProcessor binder) {
        this.binder = binder;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setBeanMetaDataStore(ConfigurationBeanFactoryMetaData beans) {
        this.metaData = beans;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        ConfigurationProperties annotation = (ConfigurationProperties)AnnotationUtils.findAnnotation(bean.getClass(), ConfigurationProperties.class);
        if (annotation != null) {
            this.beans.put(beanName, bean);
        } else if (this.metaData != null && (annotation = (ConfigurationProperties)this.metaData.findFactoryAnnotation(beanName, ConfigurationProperties.class)) != null) {
            this.beans.put(beanName, bean);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    @ManagedOperation
    public void rebind() {
        for (String name : this.beans.keySet()) {
            this.rebind(name);
        }
    }

    @ManagedOperation
    public void rebind(String name) {
        this.binder.postProcessBeforeInitialization(this.beans.get(name), name);
        if (this.applicationContext != null) {
            this.applicationContext.getAutowireCapableBeanFactory().initializeBean(this.beans.get(name), name);
        }
    }

    @ManagedAttribute
    public Set<String> getBeanNames() {
        return new HashSet<String>(this.beans.keySet());
    }

    public void onApplicationEvent(EnvironmentChangeEvent event) {
        this.rebind();
    }
}

