/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.ssh;

import java.util.HashSet;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.cloud.config.server.ssh.HostKeyAndAlgoBothExist;
import org.springframework.cloud.config.server.ssh.SshPropertyValidator;
import org.springframework.cloud.config.server.ssh.SshUri;
import org.springframework.cloud.config.server.ssh.SshUriProperties;
import org.springframework.util.StringUtils;

public class HostKeyAndAlgoBothExistValidator
implements ConstraintValidator<HostKeyAndAlgoBothExist, SshUriProperties> {
    private static final String GIT_PROPERTY_PREFIX = "spring.cloud.config.server.git.";
    private final SshPropertyValidator sshPropertyValidator = new SshPropertyValidator();

    public void initialize(HostKeyAndAlgoBothExist constrainAnnotation) {
    }

    public boolean isValid(SshUriProperties sshUriProperties, ConstraintValidatorContext context) {
        HashSet<Boolean> validationResults = new HashSet<Boolean>();
        List<SshUri> extractedProperties = this.sshPropertyValidator.extractRepoProperties(sshUriProperties);
        for (SshUri extractedProperty : extractedProperties) {
            if (!sshUriProperties.isIgnoreLocalSshSettings() || !SshPropertyValidator.isSshUri(extractedProperty.getUri())) continue;
            validationResults.add(this.isAlgorithmSpecifiedWhenHostKeySet(extractedProperty, context) && this.isHostKeySpecifiedWhenAlgorithmSet(extractedProperty, context));
        }
        return !validationResults.contains(false);
    }

    private boolean isHostKeySpecifiedWhenAlgorithmSet(SshUri sshUriProperties, ConstraintValidatorContext context) {
        if (StringUtils.hasText((String)sshUriProperties.getHostKeyAlgorithm()) && !StringUtils.hasText((String)sshUriProperties.getHostKey())) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(String.format("Property '%shostKey' must be set when '%shostKeyAlgorithm' is specified", GIT_PROPERTY_PREFIX, GIT_PROPERTY_PREFIX)).addConstraintViolation();
            return false;
        }
        return true;
    }

    private boolean isAlgorithmSpecifiedWhenHostKeySet(SshUri sshUriProperties, ConstraintValidatorContext context) {
        if (StringUtils.hasText((String)sshUriProperties.getHostKey()) && !StringUtils.hasText((String)sshUriProperties.getHostKeyAlgorithm())) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(String.format("Property '%shostKeyAlgorithm' must be set when '%shostKey' is specified", GIT_PROPERTY_PREFIX, GIT_PROPERTY_PREFIX)).addConstraintViolation();
            return false;
        }
        return true;
    }
}

