/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.validator.constraints.NotEmpty;
import org.hibernate.validator.constraints.Range;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentWatch;
import org.springframework.core.Ordered;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

@ConfigurationProperties(value="spring.cloud.config.server.vault")
@Validated
public class VaultEnvironmentRepository
implements EnvironmentRepository,
Ordered {
    public static final String VAULT_TOKEN = "X-Vault-Token";
    @NotEmpty
    private String host = "127.0.0.1";
    @Range(min=1L, max=65535L)
    private int port = 8200;
    private String scheme = "http";
    @NotEmpty
    private String backend = "secret";
    private String defaultKey = "application";
    @NotEmpty
    private String profileSeparator = ",";
    private int order = Integer.MAX_VALUE;
    private RestTemplate rest;
    private HttpServletRequest request;
    private EnvironmentWatch watch;

    public VaultEnvironmentRepository(HttpServletRequest request, EnvironmentWatch watch, RestTemplate rest) {
        this.request = request;
        this.watch = watch;
        this.rest = rest;
    }

    @Override
    public Environment findOne(String application, String profile, String label) {
        String state = this.request.getHeader("X-Config-State");
        String newState = this.watch.watch(state);
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        List<String> scrubbedProfiles = this.scrubProfiles(profiles);
        List<String> keys = this.findKeys(application, scrubbedProfiles);
        Environment environment = new Environment(application, profiles, label, null, newState);
        for (String key : keys) {
            String data = this.read(key);
            if (data == null) continue;
            YamlPropertiesFactoryBean yaml = new YamlPropertiesFactoryBean();
            yaml.setResources(new Resource[]{new ByteArrayResource(data.getBytes())});
            Properties properties = yaml.getObject();
            if (properties.isEmpty()) continue;
            environment.add(new PropertySource("vault:" + key, (Map)properties));
        }
        return environment;
    }

    private List<String> findKeys(String application, List<String> profiles) {
        ArrayList<String> keys = new ArrayList<String>();
        if (StringUtils.hasText((String)this.defaultKey) && !this.defaultKey.equals(application)) {
            keys.add(this.defaultKey);
            this.addProfiles(keys, this.defaultKey, profiles);
        }
        keys.add(application);
        this.addProfiles(keys, application, profiles);
        Collections.reverse(keys);
        return keys;
    }

    private List<String> scrubProfiles(String[] profiles) {
        ArrayList<String> scrubbedProfiles = new ArrayList<String>(Arrays.asList(profiles));
        if (scrubbedProfiles.contains("default")) {
            scrubbedProfiles.remove("default");
        }
        return scrubbedProfiles;
    }

    private void addProfiles(List<String> contexts, String baseContext, List<String> profiles) {
        for (String profile : profiles) {
            contexts.add(baseContext + this.profileSeparator + profile);
        }
    }

    String read(String key) {
        String url = String.format("%s://%s:%s/v1/{backend}/{key}", this.scheme, this.host, this.port);
        HttpHeaders headers = new HttpHeaders();
        String token = this.request.getHeader("X-Config-Token");
        if (!StringUtils.hasLength((String)token)) {
            throw new IllegalArgumentException("Missing required header: X-Config-Token");
        }
        headers.add(VAULT_TOKEN, token);
        try {
            ResponseEntity response = this.rest.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), VaultResponse.class, new Object[]{this.backend, key});
            HttpStatus status = response.getStatusCode();
            if (status == HttpStatus.OK) {
                return ((VaultResponse)response.getBody()).getData();
            }
        }
        catch (HttpStatusCodeException e) {
            if (e.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw e;
        }
        return null;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setBackend(String backend) {
        this.backend = backend;
    }

    public void setDefaultKey(String defaultKey) {
        this.defaultKey = defaultKey;
    }

    public void setProfileSeparator(String profileSeparator) {
        this.profileSeparator = profileSeparator;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class VaultResponse {
        private String auth;
        private Object data;
        @JsonProperty(value="lease_duration")
        private long leaseDuration;
        @JsonProperty(value="lease_id")
        private String leaseId;
        private boolean renewable;

        public String getAuth() {
            return this.auth;
        }

        public void setAuth(String auth) {
            this.auth = auth;
        }

        @JsonRawValue
        public String getData() {
            return this.data == null ? null : this.data.toString();
        }

        public void setData(JsonNode data) {
            this.data = data;
        }

        public long getLeaseDuration() {
            return this.leaseDuration;
        }

        public void setLeaseDuration(long leaseDuration) {
            this.leaseDuration = leaseDuration;
        }

        public String getLeaseId() {
            return this.leaseId;
        }

        public void setLeaseId(String leaseId) {
            this.leaseId = leaseId;
        }

        public boolean isRenewable() {
            return this.renewable;
        }

        public void setRenewable(boolean renewable) {
            this.renewable = renewable;
        }
    }
}

