/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.config.client.Base64;
import org.springframework.cloud.config.client.ConfigClientProperties;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.retry.annotation.Retryable;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;

@Order(value=0)
public class ConfigServicePropertySourceLocator
implements PropertySourceLocator {
    private static Log logger = LogFactory.getLog(ConfigServicePropertySourceLocator.class);
    private RestTemplate restTemplate;
    private ConfigClientProperties defaults;

    public ConfigServicePropertySourceLocator(ConfigClientProperties defaults) {
        this.defaults = defaults;
    }

    @Retryable(interceptor="configServerRetryInterceptor")
    public PropertySource<?> locate(org.springframework.core.env.Environment environment) {
        ConfigClientProperties client = this.defaults.override(environment);
        CompositePropertySource composite = new CompositePropertySource("configService");
        RestTemplate restTemplate = this.restTemplate == null ? this.getSecureRestTemplate(client) : this.restTemplate;
        Throwable error = null;
        String errorBody = null;
        try {
            String[] labels = new String[]{""};
            if (StringUtils.hasText((String)client.getLabel())) {
                labels = StringUtils.commaDelimitedListToStringArray((String)client.getLabel());
            }
            for (String label : labels) {
                Environment result = this.getRemoteEnvironment(restTemplate, client.getRawUri(), client.getName(), client.getProfile(), label.trim());
                if (result == null) continue;
                for (org.springframework.cloud.config.environment.PropertySource source : result.getPropertySources()) {
                    Map<?, ?> map = source.getSource();
                    composite.addPropertySource((PropertySource)new MapPropertySource(source.getName(), map));
                }
                return composite;
            }
        }
        catch (HttpServerErrorException e) {
            error = e;
            if (MediaType.APPLICATION_JSON.includes(e.getResponseHeaders().getContentType())) {
                errorBody = e.getResponseBodyAsString();
            }
        }
        catch (Exception e) {
            error = e;
        }
        if (client != null && client.isFailFast()) {
            throw new IllegalStateException("Could not locate PropertySource and the fail fast property is set, failing", error);
        }
        logger.warn((Object)("Could not locate PropertySource: " + (errorBody == null ? (error == null ? "label not found" : error.getMessage()) : errorBody)));
        return null;
    }

    private Environment getRemoteEnvironment(RestTemplate restTemplate, String uri, String name, String profile, String label) {
        ResponseEntity response;
        block4: {
            String path = "/{name}/{profile}";
            Object[] args = new String[]{name, profile};
            if (StringUtils.hasText((String)label)) {
                args = new String[]{name, profile, label};
                path = path + "/{label}";
            }
            response = null;
            try {
                response = restTemplate.exchange(uri + path, HttpMethod.GET, new HttpEntity((Object)null), Environment.class, args);
            }
            catch (HttpClientErrorException e) {
                if (e.getStatusCode() == HttpStatus.NOT_FOUND) break block4;
                throw e;
            }
        }
        if (response == null || response.getStatusCode() != HttpStatus.OK) {
            return null;
        }
        Environment result = (Environment)response.getBody();
        return result;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    private RestTemplate getSecureRestTemplate(ConfigClientProperties client) {
        RestTemplate template = new RestTemplate();
        String password = client.getPassword();
        if (password != null) {
            template.setInterceptors(Arrays.asList(new BasicAuthorizationInterceptor(client.getUsername(), password)));
        }
        return template;
    }

    private static class BasicAuthorizationInterceptor
    implements ClientHttpRequestInterceptor {
        private final String username;
        private final String password;

        public BasicAuthorizationInterceptor(String username, String password) {
            this.username = username;
            this.password = password == null ? "" : password;
        }

        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            byte[] token = Base64.encode((this.username + ":" + this.password).getBytes());
            request.getHeaders().add("Authorization", "Basic " + new String(token));
            return execution.execute(request, body);
        }
    }
}

