/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.resource.servlet;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.resource.IssuerUriCondition;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoders;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoderJwkSupport;

@Configuration
class OAuth2ResourceServerJwtConfiguration {
    private final OAuth2ResourceServerProperties properties;

    OAuth2ResourceServerJwtConfiguration(OAuth2ResourceServerProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnProperty(name={"spring.security.oauth2.resourceserver.jwt.jwk-set-uri"})
    @ConditionalOnMissingBean
    public JwtDecoder jwtDecoderByJwkKeySetUri() {
        return new NimbusJwtDecoderJwkSupport(this.properties.getJwt().getJwkSetUri());
    }

    @Bean
    @Conditional(value={IssuerUriCondition.class})
    @ConditionalOnMissingBean
    public JwtDecoder jwtDecoderByIssuerUri() {
        return JwtDecoders.fromOidcIssuerLocation((String)this.properties.getJwt().getIssuerUri());
    }
}

