/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.orm.jpa;

import java.util.Map;
import java.util.function.Supplier;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.autoconfigure.jdbc.DataSourceSchemaCreatedEvent;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateProperties;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateSettings;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.jdbc.EmbeddedDatabaseConnection;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;

class DataSourceInitializedPublisher
implements BeanPostProcessor {
    @Autowired
    private ApplicationContext applicationContext;
    private DataSource dataSource;
    private JpaProperties jpaProperties;
    private HibernateProperties hibernateProperties;

    DataSourceInitializedPublisher() {
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof LocalContainerEntityManagerFactoryBean) {
            LocalContainerEntityManagerFactoryBean factory = (LocalContainerEntityManagerFactoryBean)bean;
            factory.setJpaVendorAdapter((JpaVendorAdapter)new DataSourceSchemaCreatedPublisher(factory));
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        LocalContainerEntityManagerFactoryBean factory;
        if (bean instanceof DataSource) {
            this.dataSource = (DataSource)bean;
        }
        if (bean instanceof JpaProperties) {
            this.jpaProperties = (JpaProperties)bean;
        }
        if (bean instanceof HibernateProperties) {
            this.hibernateProperties = (HibernateProperties)bean;
        }
        if (bean instanceof LocalContainerEntityManagerFactoryBean && (factory = (LocalContainerEntityManagerFactoryBean)bean).getBootstrapExecutor() == null) {
            this.publishEventIfRequired(factory.getNativeEntityManagerFactory());
        }
        return bean;
    }

    private void publishEventIfRequired(EntityManagerFactory entityManagerFactory) {
        DataSource dataSource = this.findDataSource(entityManagerFactory);
        if (dataSource != null && this.isInitializingDatabase(dataSource)) {
            this.applicationContext.publishEvent((ApplicationEvent)new DataSourceSchemaCreatedEvent(dataSource));
        }
    }

    private DataSource findDataSource(EntityManagerFactory entityManagerFactory) {
        Object dataSource = entityManagerFactory.getProperties().get("javax.persistence.nonJtaDataSource");
        return dataSource instanceof DataSource ? (DataSource)dataSource : this.dataSource;
    }

    private boolean isInitializingDatabase(DataSource dataSource) {
        if (this.jpaProperties == null || this.hibernateProperties == null) {
            return true;
        }
        Supplier<String> defaultDdlAuto = () -> EmbeddedDatabaseConnection.isEmbedded((DataSource)dataSource) ? "create-drop" : "none";
        Map<String, Object> hibernate = this.hibernateProperties.determineHibernateProperties(this.jpaProperties.getProperties(), new HibernateSettings().ddlAuto(defaultDdlAuto));
        return hibernate.containsKey("hibernate.hbm2ddl.auto");
    }

    final class DataSourceSchemaCreatedPublisher
    implements JpaVendorAdapter {
        private final JpaVendorAdapter delegate;
        private final LocalContainerEntityManagerFactoryBean factory;

        private DataSourceSchemaCreatedPublisher(LocalContainerEntityManagerFactoryBean factory) {
            this.delegate = factory.getJpaVendorAdapter();
            this.factory = factory;
        }

        public PersistenceProvider getPersistenceProvider() {
            return this.delegate.getPersistenceProvider();
        }

        public String getPersistenceProviderRootPackage() {
            return this.delegate.getPersistenceProviderRootPackage();
        }

        public Map<String, ?> getJpaPropertyMap(PersistenceUnitInfo pui) {
            return this.delegate.getJpaPropertyMap(pui);
        }

        public Map<String, ?> getJpaPropertyMap() {
            return this.delegate.getJpaPropertyMap();
        }

        public JpaDialect getJpaDialect() {
            return this.delegate.getJpaDialect();
        }

        public Class<? extends EntityManagerFactory> getEntityManagerFactoryInterface() {
            return this.delegate.getEntityManagerFactoryInterface();
        }

        public Class<? extends EntityManager> getEntityManagerInterface() {
            return this.delegate.getEntityManagerInterface();
        }

        public void postProcessEntityManagerFactory(EntityManagerFactory emf) {
            this.delegate.postProcessEntityManagerFactory(emf);
            AsyncTaskExecutor bootstrapExecutor = this.factory.getBootstrapExecutor();
            if (bootstrapExecutor != null) {
                bootstrapExecutor.execute(() -> DataSourceInitializedPublisher.this.publishEventIfRequired(emf));
            }
        }
    }

    static class Registrar
    implements ImportBeanDefinitionRegistrar {
        private static final String BEAN_NAME = "dataSourceInitializedPublisher";

        Registrar() {
        }

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            if (!registry.containsBeanDefinition(BEAN_NAME)) {
                GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
                beanDefinition.setBeanClass(DataSourceInitializedPublisher.class);
                beanDefinition.setRole(2);
                beanDefinition.setSynthetic(true);
                registry.registerBeanDefinition(BEAN_NAME, (BeanDefinition)beanDefinition);
            }
        }
    }
}

