/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.couchbase;

import java.time.Duration;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="spring.couchbase")
public class CouchbaseProperties {
    private List<String> bootstrapHosts;
    private final Bucket bucket = new Bucket();
    private final Env env = new Env();

    public List<String> getBootstrapHosts() {
        return this.bootstrapHosts;
    }

    public void setBootstrapHosts(List<String> bootstrapHosts) {
        this.bootstrapHosts = bootstrapHosts;
    }

    public Bucket getBucket() {
        return this.bucket;
    }

    public Env getEnv() {
        return this.env;
    }

    public static class Timeouts {
        private Duration connect = Duration.ofMillis(5000L);
        private Duration keyValue = Duration.ofMillis(2500L);
        private Duration query = Duration.ofMillis(7500L);
        private Duration socketConnect = Duration.ofMillis(1000L);
        private Duration view = Duration.ofMillis(7500L);

        public Duration getConnect() {
            return this.connect;
        }

        public void setConnect(Duration connect) {
            this.connect = connect;
        }

        public Duration getKeyValue() {
            return this.keyValue;
        }

        public void setKeyValue(Duration keyValue) {
            this.keyValue = keyValue;
        }

        public Duration getQuery() {
            return this.query;
        }

        public void setQuery(Duration query) {
            this.query = query;
        }

        public Duration getSocketConnect() {
            return this.socketConnect;
        }

        public void setSocketConnect(Duration socketConnect) {
            this.socketConnect = socketConnect;
        }

        public Duration getView() {
            return this.view;
        }

        public void setView(Duration view) {
            this.view = view;
        }
    }

    public static class Ssl {
        private Boolean enabled;
        private String keyStore;
        private String keyStorePassword;

        public Boolean getEnabled() {
            return this.enabled != null ? this.enabled : StringUtils.hasText((String)this.keyStore);
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public String getKeyStore() {
            return this.keyStore;
        }

        public void setKeyStore(String keyStore) {
            this.keyStore = keyStore;
        }

        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public void setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
        }
    }

    public static class Endpoints {
        private int keyValue = 1;
        private int query = 1;
        private int view = 1;

        public int getKeyValue() {
            return this.keyValue;
        }

        public void setKeyValue(int keyValue) {
            this.keyValue = keyValue;
        }

        public int getQuery() {
            return this.query;
        }

        public void setQuery(int query) {
            this.query = query;
        }

        public int getView() {
            return this.view;
        }

        public void setView(int view) {
            this.view = view;
        }
    }

    public static class Env {
        private final Endpoints endpoints = new Endpoints();
        private final Ssl ssl = new Ssl();
        private final Timeouts timeouts = new Timeouts();

        public Endpoints getEndpoints() {
            return this.endpoints;
        }

        public Ssl getSsl() {
            return this.ssl;
        }

        public Timeouts getTimeouts() {
            return this.timeouts;
        }
    }

    public static class Bucket {
        private String name = "default";
        private String password = "";

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }
}

