/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.session;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.session.SessionProperties;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.util.Assert;

public class JdbcSessionDatabaseInitializer {
    private static Map<String, String> ALIASES;
    private SessionProperties properties;
    private DataSource dataSource;
    private ResourceLoader resourceLoader;

    public JdbcSessionDatabaseInitializer(SessionProperties properties, DataSource dataSource, ResourceLoader resourceLoader) {
        Assert.notNull((Object)properties, (String)"SessionProperties must not be null");
        Assert.notNull((Object)dataSource, (String)"DataSource must not be null");
        Assert.notNull((Object)resourceLoader, (String)"ResourceLoader must not be null");
        this.properties = properties;
        this.dataSource = dataSource;
        this.resourceLoader = resourceLoader;
    }

    @PostConstruct
    protected void initialize() {
        if (this.properties.getJdbc().getInitializer().isEnabled()) {
            ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
            String schemaLocation = this.properties.getJdbc().getSchema();
            schemaLocation = schemaLocation.replace("@@platform@@", this.getPlatform());
            populator.addScript(this.resourceLoader.getResource(schemaLocation));
            populator.setContinueOnError(true);
            DatabasePopulatorUtils.execute((DatabasePopulator)populator, (DataSource)this.dataSource);
        }
    }

    private String getPlatform() {
        String databaseName = this.getDatabaseName();
        if (ALIASES.containsKey(databaseName)) {
            return ALIASES.get(databaseName);
        }
        return databaseName;
    }

    private String getDatabaseName() {
        try {
            String databaseProductName = JdbcUtils.extractDatabaseMetaData((DataSource)this.dataSource, (String)"getDatabaseProductName").toString();
            return JdbcUtils.commonDatabaseName((String)databaseProductName).toLowerCase();
        }
        catch (MetaDataAccessException ex) {
            throw new IllegalStateException("Unable to detect database type", ex);
        }
    }

    static {
        HashMap<String, String> aliases = new HashMap<String, String>();
        aliases.put("apache derby", "derby");
        aliases.put("hsql database engine", "hsqldb");
        aliases.put("microsoft sql server", "sqlserver");
        ALIASES = Collections.unmodifiableMap(aliases);
    }
}

