/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import java.io.File;
import java.net.InetAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.catalina.Context;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.valves.AccessLogValve;
import org.apache.catalina.valves.RemoteIpValve;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.context.embedded.InitParameterConfiguringServletContextInitializer;
import org.springframework.boot.context.embedded.ServletContextInitializer;
import org.springframework.boot.context.embedded.Ssl;
import org.springframework.boot.context.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.undertow.UndertowEmbeddedServletContainerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.core.Ordered;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="server", ignoreUnknownFields=false)
public class ServerProperties
implements EmbeddedServletContainerCustomizer,
Ordered {
    private Integer port;
    private InetAddress address;
    private Integer sessionTimeout;
    private String contextPath;
    @NestedConfigurationProperty
    private Ssl ssl;
    @NotNull
    private String servletPath = "/";
    private final Tomcat tomcat = new Tomcat();
    private final Undertow undertow = new Undertow();
    private final Map<String, String> contextParameters = new HashMap<String, String>();

    public int getOrder() {
        return 0;
    }

    public Tomcat getTomcat() {
        return this.tomcat;
    }

    public Undertow getUndertow() {
        return this.undertow;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getServletMapping() {
        if (this.servletPath.equals("") || this.servletPath.equals("/")) {
            return "/";
        }
        if (this.servletPath.contains("*")) {
            return this.servletPath;
        }
        if (this.servletPath.endsWith("/")) {
            return this.servletPath + "*";
        }
        return this.servletPath + "/*";
    }

    public String getServletPrefix() {
        String result = this.servletPath;
        if (result.contains("*")) {
            result = result.substring(0, result.indexOf("*"));
        }
        if (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public Integer getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(Integer sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    public Map<String, String> getContextParameters() {
        return this.contextParameters;
    }

    public void setLoader(String value) {
    }

    public void customize(ConfigurableEmbeddedServletContainer container) {
        if (this.getPort() != null) {
            container.setPort(this.getPort().intValue());
        }
        if (this.getAddress() != null) {
            container.setAddress(this.getAddress());
        }
        if (this.getContextPath() != null) {
            container.setContextPath(this.getContextPath());
        }
        if (this.getSessionTimeout() != null) {
            container.setSessionTimeout(this.getSessionTimeout().intValue());
        }
        if (this.getSsl() != null) {
            container.setSsl(this.getSsl());
        }
        if (container instanceof TomcatEmbeddedServletContainerFactory) {
            this.getTomcat().customizeTomcat((TomcatEmbeddedServletContainerFactory)container);
        }
        if (container instanceof UndertowEmbeddedServletContainerFactory) {
            this.getUndertow().customizeUndertow((UndertowEmbeddedServletContainerFactory)container);
        }
        container.addInitializers(new ServletContextInitializer[]{new InitParameterConfiguringServletContextInitializer(this.getContextParameters())});
    }

    public String[] getPathsArray(Collection<String> paths) {
        String[] result = new String[paths.size()];
        int i = 0;
        for (String path : paths) {
            result[i++] = this.getPath(path);
        }
        return result;
    }

    public String[] getPathsArray(String[] paths) {
        String[] result = new String[paths.length];
        int i = 0;
        for (String path : paths) {
            result[i++] = this.getPath(path);
        }
        return result;
    }

    public String getPath(String path) {
        String prefix = this.getServletPrefix();
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return prefix + path;
    }

    public static class Undertow {
        private Integer bufferSize;
        private Integer buffersPerRegion;
        private Integer ioThreads;
        private Integer workerThreads;
        private Boolean directBuffers;

        public Integer getBufferSize() {
            return this.bufferSize;
        }

        public void setBufferSize(Integer bufferSize) {
            this.bufferSize = bufferSize;
        }

        public Integer getBuffersPerRegion() {
            return this.buffersPerRegion;
        }

        public void setBuffersPerRegion(Integer buffersPerRegion) {
            this.buffersPerRegion = buffersPerRegion;
        }

        public Integer getIoThreads() {
            return this.ioThreads;
        }

        public void setIoThreads(Integer ioThreads) {
            this.ioThreads = ioThreads;
        }

        public Integer getWorkerThreads() {
            return this.workerThreads;
        }

        public void setWorkerThreads(Integer workerThreads) {
            this.workerThreads = workerThreads;
        }

        public Boolean getDirectBuffers() {
            return this.directBuffers;
        }

        public void setDirectBuffers(Boolean directBuffers) {
            this.directBuffers = directBuffers;
        }

        void customizeUndertow(UndertowEmbeddedServletContainerFactory factory) {
            factory.setBufferSize(this.bufferSize);
            factory.setBuffersPerRegion(this.buffersPerRegion);
            factory.setIoThreads(this.ioThreads);
            factory.setWorkerThreads(this.workerThreads);
            factory.setDirectBuffers(this.directBuffers);
        }
    }

    public static class Tomcat {
        private String accessLogPattern;
        private boolean accessLogEnabled = false;
        private String internalProxies = "10\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|192\\.168\\.\\d{1,3}\\.\\d{1,3}|169\\.254\\.\\d{1,3}\\.\\d{1,3}|127\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}";
        private String protocolHeader;
        private String protocolHeaderHttpsValue = "https";
        private String portHeader;
        private String remoteIpHeader;
        private File basedir;
        private int backgroundProcessorDelay = 30;
        private int maxThreads = 0;
        private int maxHttpHeaderSize = 0;
        private String uriEncoding;
        private String compression = "off";
        private String compressableMimeTypes = "text/html,text/xml,text/plain";

        public int getMaxThreads() {
            return this.maxThreads;
        }

        public void setMaxThreads(int maxThreads) {
            this.maxThreads = maxThreads;
        }

        public int getMaxHttpHeaderSize() {
            return this.maxHttpHeaderSize;
        }

        public void setMaxHttpHeaderSize(int maxHttpHeaderSize) {
            this.maxHttpHeaderSize = maxHttpHeaderSize;
        }

        public boolean getAccessLogEnabled() {
            return this.accessLogEnabled;
        }

        public void setAccessLogEnabled(boolean accessLogEnabled) {
            this.accessLogEnabled = accessLogEnabled;
        }

        public int getBackgroundProcessorDelay() {
            return this.backgroundProcessorDelay;
        }

        public void setBackgroundProcessorDelay(int backgroundProcessorDelay) {
            this.backgroundProcessorDelay = backgroundProcessorDelay;
        }

        public File getBasedir() {
            return this.basedir;
        }

        public void setBasedir(File basedir) {
            this.basedir = basedir;
        }

        public String getAccessLogPattern() {
            return this.accessLogPattern;
        }

        public void setAccessLogPattern(String accessLogPattern) {
            this.accessLogPattern = accessLogPattern;
        }

        public String getCompressableMimeTypes() {
            return this.compressableMimeTypes;
        }

        public void setCompressableMimeTypes(String compressableMimeTypes) {
            this.compressableMimeTypes = compressableMimeTypes;
        }

        public String getCompression() {
            return this.compression;
        }

        public void setCompression(String compression) {
            this.compression = compression;
        }

        public String getInternalProxies() {
            return this.internalProxies;
        }

        public void setInternalProxies(String internalProxies) {
            this.internalProxies = internalProxies;
        }

        public String getProtocolHeader() {
            return this.protocolHeader;
        }

        public void setProtocolHeader(String protocolHeader) {
            this.protocolHeader = protocolHeader;
        }

        public String getProtocolHeaderHttpsValue() {
            return this.protocolHeaderHttpsValue;
        }

        public void setProtocolHeaderHttpsValue(String protocolHeaderHttpsValue) {
            this.protocolHeaderHttpsValue = protocolHeaderHttpsValue;
        }

        public String getPortHeader() {
            return this.portHeader;
        }

        public void setPortHeader(String portHeader) {
            this.portHeader = portHeader;
        }

        public String getRemoteIpHeader() {
            return this.remoteIpHeader;
        }

        public void setRemoteIpHeader(String remoteIpHeader) {
            this.remoteIpHeader = remoteIpHeader;
        }

        public String getUriEncoding() {
            return this.uriEncoding;
        }

        public void setUriEncoding(String uriEncoding) {
            this.uriEncoding = uriEncoding;
        }

        void customizeTomcat(TomcatEmbeddedServletContainerFactory factory) {
            RemoteIpValve valve;
            if (this.getBasedir() != null) {
                factory.setBaseDirectory(this.getBasedir());
            }
            factory.addContextCustomizers(new TomcatContextCustomizer[]{new TomcatContextCustomizer(){

                public void customize(Context context) {
                    context.setBackgroundProcessorDelay(Tomcat.this.backgroundProcessorDelay);
                }
            }});
            String remoteIpHeader = this.getRemoteIpHeader();
            String protocolHeader = this.getProtocolHeader();
            if (StringUtils.hasText((String)remoteIpHeader) || StringUtils.hasText((String)protocolHeader)) {
                valve = new RemoteIpValve();
                valve.setRemoteIpHeader(remoteIpHeader);
                valve.setProtocolHeader(protocolHeader);
                valve.setInternalProxies(this.getInternalProxies());
                valve.setPortHeader(this.getPortHeader());
                valve.setProtocolHeaderHttpsValue(this.getProtocolHeaderHttpsValue());
                factory.addContextValves(new Valve[]{valve});
            }
            if (this.maxThreads > 0) {
                factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{new TomcatConnectorCustomizer(){

                    public void customize(Connector connector) {
                        ProtocolHandler handler = connector.getProtocolHandler();
                        if (handler instanceof AbstractProtocol) {
                            AbstractProtocol protocol = (AbstractProtocol)handler;
                            protocol.setMaxThreads(Tomcat.this.maxThreads);
                        }
                    }
                }});
            }
            if (this.maxHttpHeaderSize > 0) {
                factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{new TomcatConnectorCustomizer(){

                    public void customize(Connector connector) {
                        ProtocolHandler handler = connector.getProtocolHandler();
                        if (handler instanceof AbstractHttp11Protocol) {
                            AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                            protocol.setMaxHttpHeaderSize(Tomcat.this.maxHttpHeaderSize);
                        }
                    }
                }});
            }
            factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{new TomcatConnectorCustomizer(){

                public void customize(Connector connector) {
                    ProtocolHandler handler = connector.getProtocolHandler();
                    if (handler instanceof AbstractHttp11Protocol) {
                        AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                        protocol.setCompression(this.coerceCompression(Tomcat.this.compression));
                        protocol.setCompressableMimeTypes(Tomcat.this.compressableMimeTypes);
                    }
                }

                private String coerceCompression(String compression) {
                    if ("true".equalsIgnoreCase(compression)) {
                        return "on";
                    }
                    if ("false".equalsIgnoreCase(compression)) {
                        return "off";
                    }
                    return compression;
                }
            }});
            if (this.accessLogEnabled) {
                valve = new AccessLogValve();
                String accessLogPattern = this.getAccessLogPattern();
                if (accessLogPattern != null) {
                    valve.setPattern(accessLogPattern);
                } else {
                    valve.setPattern("common");
                }
                valve.setSuffix(".log");
                factory.addContextValves(new Valve[]{valve});
            }
            if (this.getUriEncoding() != null) {
                factory.setUriEncoding(this.getUriEncoding());
            }
        }
    }
}

