/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.amqp;

import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Message;
import org.springframework.batch.item.ItemReader;
import org.springframework.util.Assert;

public class AmqpItemReader<T>
implements ItemReader<T> {
    private final AmqpTemplate amqpTemplate;
    private Class<? extends T> itemType;

    public AmqpItemReader(AmqpTemplate amqpTemplate) {
        Assert.notNull((Object)amqpTemplate, (String)"AmpqTemplate must not be null");
        this.amqpTemplate = amqpTemplate;
    }

    @Override
    public T read() {
        if (this.itemType != null && this.itemType.isAssignableFrom(Message.class)) {
            return (T)this.amqpTemplate.receive();
        }
        Object result = this.amqpTemplate.receiveAndConvert();
        if (this.itemType != null && result != null) {
            Assert.state((boolean)this.itemType.isAssignableFrom(result.getClass()), (String)("Received message payload of wrong type: expected [" + this.itemType + "]"));
        }
        return (T)result;
    }

    public void setItemType(Class<? extends T> itemType) {
        Assert.notNull(itemType, (String)"Item type cannot be null");
        this.itemType = itemType;
    }
}

