/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.support;

import org.springframework.batch.item.database.support.AbstractSqlPagingQueryProvider;
import org.springframework.batch.item.database.support.SqlPagingQueryUtils;

public class PostgresPagingQueryProvider
extends AbstractSqlPagingQueryProvider {
    public String generateFirstPageQuery(int pageSize) {
        return SqlPagingQueryUtils.generateLimitSqlQuery(this, false, this.buildLimitClause(pageSize));
    }

    public String generateRemainingPagesQuery(int pageSize) {
        return SqlPagingQueryUtils.generateLimitSqlQuery(this, true, this.buildLimitClause(pageSize));
    }

    private String buildLimitClause(int pageSize) {
        return "LIMIT " + pageSize;
    }

    public String generateJumpToItemQuery(int itemIndex, int pageSize) {
        int page = itemIndex / pageSize;
        int offset = page * pageSize - 1;
        offset = offset < 0 ? 0 : offset;
        String limitClause = "LIMIT 1 OFFSET " + offset;
        return SqlPagingQueryUtils.generateLimitJumpToQuery(this, limitClause);
    }
}

