/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.support;

import java.util.ArrayList;
import javax.sql.DataSource;
import org.springframework.batch.item.database.JdbcParameterUtils;
import org.springframework.batch.item.database.PagingQueryProvider;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractSqlPagingQueryProvider
implements PagingQueryProvider {
    private String selectClause;
    private String fromClause;
    private String whereClause;
    private String sortKey;
    private boolean ascending = true;
    private int parameterCount;
    private boolean usingNamedParameters;

    public void setSelectClause(String selectClause) {
        this.selectClause = this.removeKeyWord("select", selectClause);
    }

    protected String getSelectClause() {
        return this.selectClause;
    }

    public void setFromClause(String fromClause) {
        this.fromClause = this.removeKeyWord("from", fromClause);
    }

    protected String getFromClause() {
        return this.fromClause;
    }

    public void setWhereClause(String whereClause) {
        this.whereClause = StringUtils.hasText((String)whereClause) ? this.removeKeyWord("where", whereClause) : null;
    }

    protected String getWhereClause() {
        return this.whereClause;
    }

    public void setSortKey(String sortKey) {
        this.sortKey = sortKey;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public String getSortKey() {
        return this.sortKey;
    }

    public String getSortKeyWithoutAlias() {
        int columnIndex;
        String sortKey = this.getSortKey();
        int separator = sortKey.indexOf(46);
        if (separator > 0 && (columnIndex = separator + 1) < sortKey.length()) {
            sortKey = sortKey.substring(columnIndex);
        }
        return sortKey;
    }

    public int getParameterCount() {
        return this.parameterCount;
    }

    public boolean isUsingNamedParameters() {
        return this.usingNamedParameters;
    }

    protected String getSortKeyPlaceHolder() {
        return this.usingNamedParameters ? ":_sortKey" : "?";
    }

    public void init(DataSource dataSource) throws Exception {
        Assert.notNull((Object)dataSource);
        Assert.hasLength((String)this.selectClause, (String)"selectClause must be specified");
        Assert.hasLength((String)this.fromClause, (String)"fromClause must be specified");
        Assert.hasLength((String)this.sortKey, (String)"sortKey must be specified");
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ").append(this.selectClause);
        sql.append(" FROM ").append(this.fromClause);
        if (this.whereClause != null) {
            sql.append(" WHERE ").append(this.whereClause);
        }
        ArrayList<String> namedParameters = new ArrayList<String>();
        this.parameterCount = JdbcParameterUtils.countParameterPlaceholders(sql.toString(), namedParameters);
        if (namedParameters.size() > 0) {
            if (this.parameterCount != namedParameters.size()) {
                throw new InvalidDataAccessApiUsageException("You can't use both named parameters and classic \"?\" placeholders: " + sql);
            }
            this.usingNamedParameters = true;
        }
    }

    public abstract String generateFirstPageQuery(int var1);

    public abstract String generateRemainingPagesQuery(int var1);

    public abstract String generateJumpToItemQuery(int var1, int var2);

    private String removeKeyWord(String keyWord, String clause) {
        String temp = clause.trim();
        String keyWordString = keyWord + " ";
        if (temp.toLowerCase().startsWith(keyWordString) && temp.length() > keyWordString.length()) {
            return temp.substring(keyWordString.length());
        }
        return temp;
    }
}

