/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.datasource.ConnectionProxy;
import org.springframework.jdbc.datasource.SmartDataSource;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedConnectionDataSourceProxy
implements SmartDataSource,
InitializingBean {
    private DataSource dataSource;
    private Connection closeSuppressedConnection = null;
    private boolean borrowedConnection = false;
    private final Object connectionMonitor = new Object();

    public ExtendedConnectionDataSourceProxy() {
    }

    public ExtendedConnectionDataSourceProxy(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public boolean shouldClose(Connection connection) {
        boolean shouldClose;
        boolean bl = shouldClose = !this.isCloseSuppressionActive(connection);
        if (this.borrowedConnection && this.closeSuppressedConnection.equals(connection)) {
            this.borrowedConnection = false;
        }
        return shouldClose;
    }

    public boolean isCloseSuppressionActive(Connection connection) {
        if (connection == null) {
            return false;
        }
        return connection.equals(this.closeSuppressedConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCloseSuppression(Connection connection) {
        Object object = this.connectionMonitor;
        synchronized (object) {
            this.closeSuppressedConnection = connection;
            if (TransactionSynchronizationManager.isActualTransactionActive()) {
                this.borrowedConnection = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCloseSuppression(Connection connection) {
        Object object = this.connectionMonitor;
        synchronized (object) {
            this.closeSuppressedConnection = null;
            this.borrowedConnection = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        Object object = this.connectionMonitor;
        synchronized (object) {
            return this.initConnection(null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(String username, String password) throws SQLException {
        Object object = this.connectionMonitor;
        synchronized (object) {
            return this.initConnection(username, password);
        }
    }

    private boolean completeCloseCall(Connection connection) {
        if (this.borrowedConnection && this.closeSuppressedConnection.equals(connection)) {
            this.borrowedConnection = false;
        }
        return this.isCloseSuppressionActive(connection);
    }

    private Connection initConnection(String username, String password) throws SQLException {
        if (this.closeSuppressedConnection != null && !this.borrowedConnection) {
            this.borrowedConnection = true;
            return this.closeSuppressedConnection;
        }
        Connection target = username != null ? this.dataSource.getConnection(username, password) : this.dataSource.getConnection();
        Connection connection = this.getCloseSuppressingConnectionProxy(target);
        return connection;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSource.setLogWriter(out);
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }

    protected Connection getCloseSuppressingConnectionProxy(Connection target) {
        return (Connection)Proxy.newProxyInstance(ConnectionProxy.class.getClassLoader(), new Class[]{ConnectionProxy.class}, (InvocationHandler)new CloseSuppressingInvocationHandler(target, this));
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(SmartDataSource.class) || iface.isAssignableFrom(this.dataSource.getClass());
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(SmartDataSource.class)) {
            ExtendedConnectionDataSourceProxy casted = this;
            return (T)casted;
        }
        if (iface.isAssignableFrom(this.dataSource.getClass())) {
            DataSource casted = this.dataSource;
            return (T)casted;
        }
        throw new SQLException("Unsupported class " + iface.getSimpleName());
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.dataSource);
    }

    public Logger getParentLogger() {
        throw new UnsupportedOperationException();
    }

    private static class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final Connection target;
        private final ExtendedConnectionDataSourceProxy dataSource;

        public CloseSuppressingInvocationHandler(Connection target, ExtendedConnectionDataSourceProxy dataSource) {
            this.dataSource = dataSource;
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(System.identityHashCode(proxy));
            }
            if (method.getName().equals("close")) {
                if (this.dataSource.completeCloseCall((Connection)proxy)) {
                    return null;
                }
                this.target.close();
                return null;
            }
            if (method.getName().equals("getTargetConnection")) {
                return this.target;
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

