/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.rabbit.connection.ChannelListener;
import org.springframework.amqp.rabbit.connection.CompositeChannelListener;
import org.springframework.amqp.rabbit.connection.CompositeConnectionListener;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionListener;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.amqp.rabbit.connection.SimpleConnection;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConnectionFactory
implements ConnectionFactory,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final com.rabbitmq.client.ConnectionFactory rabbitConnectionFactory;
    private final CompositeConnectionListener connectionListener = new CompositeConnectionListener();
    private final CompositeChannelListener channelListener = new CompositeChannelListener();

    public AbstractConnectionFactory(com.rabbitmq.client.ConnectionFactory rabbitConnectionFactory) {
        Assert.notNull((Object)rabbitConnectionFactory, (String)"Target ConnectionFactory must not be null");
        this.rabbitConnectionFactory = rabbitConnectionFactory;
    }

    public void setUsername(String username) {
        this.rabbitConnectionFactory.setUsername(username);
    }

    public void setPassword(String password) {
        this.rabbitConnectionFactory.setPassword(password);
    }

    public void setHost(String host) {
        this.rabbitConnectionFactory.setHost(host);
    }

    @Override
    public String getHost() {
        return this.rabbitConnectionFactory.getHost();
    }

    public void setVirtualHost(String virtualHost) {
        this.rabbitConnectionFactory.setVirtualHost(virtualHost);
    }

    @Override
    public String getVirtualHost() {
        return this.rabbitConnectionFactory.getVirtualHost();
    }

    public void setPort(int port) {
        this.rabbitConnectionFactory.setPort(port);
    }

    @Override
    public int getPort() {
        return this.rabbitConnectionFactory.getPort();
    }

    protected ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    protected ChannelListener getChannelListener() {
        return this.channelListener;
    }

    public void setConnectionListeners(List<? extends ConnectionListener> listeners) {
        this.connectionListener.setDelegates(listeners);
    }

    @Override
    public void addConnectionListener(ConnectionListener listener) {
        this.connectionListener.addDelegate(listener);
    }

    public void setChannelListeners(List<? extends ChannelListener> listeners) {
        this.channelListener.setDelegates(listeners);
    }

    public void addChannelListener(ChannelListener listener) {
        this.channelListener.addDelegate(listener);
    }

    protected final Connection createBareConnection() {
        try {
            return new SimpleConnection(this.rabbitConnectionFactory.newConnection());
        }
        catch (IOException e) {
            throw RabbitUtils.convertRabbitAccessException(e);
        }
    }

    protected final String getDefaultHostName() {
        String temp;
        try {
            InetAddress localMachine = InetAddress.getLocalHost();
            temp = localMachine.getHostName();
            this.logger.debug((Object)("Using hostname [" + temp + "] for hostname."));
        }
        catch (UnknownHostException e) {
            this.logger.warn((Object)"Could not get host name, using 'localhost' as default value", (Throwable)e);
            temp = "localhost";
        }
        return temp;
    }

    public void destroy() {
    }
}

