/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.rdf;

import java.util.BitSet;
import org.semarglproject.rdf.ParseException;
import org.semarglproject.rdf.ProcessorGraphHandler;
import org.semarglproject.sink.CharSink;
import org.semarglproject.sink.DataSink;
import org.semarglproject.sink.Pipe;
import org.semarglproject.sink.TripleSink;
import org.semarglproject.xml.XmlUtils;

public final class NTriplesParser
extends Pipe<TripleSink>
implements CharSink {
    public static final String ERROR = "http://semarglproject.org/ntriples/Error";
    private static final short MODE_SAVE_UNTIL = 1;
    private static final short MODE_SAVE_WHILE = 2;
    private String subj = null;
    private String pred = null;
    private String buffer = null;
    private int pos = -1;
    private int limit = -1;
    private ProcessorGraphHandler processorGraphHandler = null;
    private boolean ignoreErrors = false;

    private NTriplesParser(TripleSink sink) {
        super((DataSink)sink);
    }

    public static CharSink connect(TripleSink sink) {
        return new NTriplesParser(sink);
    }

    private void error(String msg) throws ParseException {
        if (this.processorGraphHandler != null) {
            this.processorGraphHandler.error(ERROR, msg);
        }
        if (!this.ignoreErrors) {
            throw new ParseException(msg);
        }
    }

    private static boolean isEntirelyWhitespaceOrEmpty(String s) {
        for (char c : s.toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    private void skipWhitespace() {
        while (this.pos < this.limit && XmlUtils.WHITESPACE.get(this.buffer.charAt(this.pos))) {
            ++this.pos;
        }
    }

    public void process(String line) throws ParseException {
        if (NTriplesParser.isEntirelyWhitespaceOrEmpty(line)) {
            return;
        }
        this.buffer = line;
        this.pos = 0;
        this.limit = line.length();
        this.subj = null;
        this.pred = null;
        boolean nextLine = false;
        while (this.pos < this.limit && !nextLine) {
            this.skipWhitespace();
            switch (line.charAt(this.pos)) {
                case '<': {
                    ++this.pos;
                    String value = this.unescape(this.getToken((short)1, XmlUtils.GT));
                    nextLine = this.processNonLiteral(value);
                    break;
                }
                case '_': {
                    String value = this.unescape(this.getToken((short)2, XmlUtils.ID));
                    nextLine = this.processNonLiteral(value);
                    break;
                }
                case '\"': {
                    ++this.pos;
                    String value = this.unescape(this.getToken((short)1, XmlUtils.QUOTE));
                    while (line.charAt(this.pos - 2) == '\\') {
                        value = value + '\"' + this.unescape(this.getToken((short)1, XmlUtils.QUOTE));
                    }
                    if (this.subj == null || this.pred == null) {
                        this.error("Literal before subject or predicate");
                        return;
                    }
                    this.parseLiteral(this.subj, this.pred, value);
                    nextLine = true;
                    break;
                }
                case '#': {
                    return;
                }
                default: {
                    this.error("Unknown token '" + line.charAt(this.pos) + "' in line '" + line + "'");
                    return;
                }
            }
            ++this.pos;
        }
        this.skipWhitespace();
        if (this.pos != this.limit && line.charAt(this.pos) != '#' && line.charAt(this.pos) != '.') {
            this.error("Error parsing triple");
        }
    }

    private boolean processNonLiteral(String value) {
        boolean nextLine = false;
        if (this.subj == null) {
            this.subj = value;
        } else if (this.pred == null) {
            this.pred = value;
        } else {
            ((TripleSink)this.sink).addNonLiteral(this.subj, this.pred, value);
            nextLine = true;
        }
        return nextLine;
    }

    private void parseLiteral(String subj, String pred, String value) {
        if (this.pos + 2 >= this.limit - 1) {
            ((TripleSink)this.sink).addPlainLiteral(subj, pred, value, null);
        } else if (this.buffer.charAt(this.pos) == '^' && this.buffer.charAt(this.pos + 1) == '^' && this.buffer.charAt(this.pos + 2) == '<') {
            this.pos += 3;
            String type = this.getToken((short)1, XmlUtils.GT);
            ((TripleSink)this.sink).addTypedLiteral(subj, pred, value, type);
        } else if (this.buffer.charAt(this.pos) == '@') {
            ++this.pos;
            String lang = this.getToken((short)1, XmlUtils.WHITESPACE);
            ((TripleSink)this.sink).addPlainLiteral(subj, pred, value, lang);
        } else {
            ((TripleSink)this.sink).addPlainLiteral(subj, pred, value, null);
        }
    }

    private String getToken(short mode, BitSet checker) {
        int savedLength = 0;
        int startPos = this.pos;
        block4: while (this.pos < this.limit) {
            switch (mode) {
                case 2: {
                    if (!checker.get(this.buffer.charAt(this.pos))) break block4;
                    ++savedLength;
                    if (this.pos != this.limit - 1) break;
                    break block4;
                }
                case 1: {
                    if (checker.get(this.buffer.charAt(this.pos))) {
                        ++this.pos;
                        break block4;
                    }
                    ++savedLength;
                    if (this.pos != this.limit - 1) break;
                    ++this.pos;
                    break block4;
                }
                default: {
                    throw new IllegalStateException("Unknown mode = " + mode);
                }
            }
            ++this.pos;
        }
        return this.buffer.substring(startPos, startPos + savedLength);
    }

    private String unescape(String str) throws ParseException {
        int limit = str.length();
        StringBuilder result = new StringBuilder(limit);
        block11: for (int i = 0; i < limit; ++i) {
            char ch = str.charAt(i);
            if (ch != '\\') {
                result.append(ch);
                continue;
            }
            if (++i == limit) break;
            ch = str.charAt(i);
            switch (ch) {
                case '\"': 
                case '\'': 
                case '\\': {
                    result.append(ch);
                    continue block11;
                }
                case 'b': {
                    result.append('\b');
                    continue block11;
                }
                case 'f': {
                    result.append('\f');
                    continue block11;
                }
                case 'n': {
                    result.append('\n');
                    continue block11;
                }
                case 'r': {
                    result.append('\r');
                    continue block11;
                }
                case 't': {
                    result.append('\t');
                    continue block11;
                }
                case 'u': {
                    if (i + 4 >= limit) {
                        this.error("Error parsing escaped char");
                    }
                    String code = str.substring(i + 1, i + 5);
                    i += 4;
                    try {
                        int value = Integer.parseInt(code, 16);
                        result.append((char)value);
                    }
                    catch (NumberFormatException nfe) {
                        this.error("Error parsing escaped char");
                    }
                    continue block11;
                }
                default: {
                    result.append(ch);
                }
            }
        }
        return result.toString();
    }

    public void setBaseUri(String baseUri) {
    }

    protected boolean setPropertyInternal(String key, Object value) {
        if ("http://semarglproject.org/core/properties/processor-graph-handler".equals(key) && value instanceof ProcessorGraphHandler) {
            this.processorGraphHandler = (ProcessorGraphHandler)value;
        } else if ("http://semarglproject.org/core/properties/enable-error-recovery".equals(key) && value instanceof Boolean) {
            this.ignoreErrors = (Boolean)value;
        }
        return false;
    }
}

