/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;

public class CommandLine {
    private static final Method JDK6_CAN_EXECUTE = CommandLine.findJdk6CanExecuteMethod();
    private final String[] commandAndArgs;
    private StreamDrainer drainer;
    private int exitCode;
    private boolean executed;
    private Process proc;

    public CommandLine(String executable, String ... args) {
        this.commandAndArgs = new String[args.length + 1];
        this.commandAndArgs[0] = CommandLine.findExecutable(executable);
        int index = 1;
        for (String arg : args) {
            this.commandAndArgs[index++] = arg;
        }
    }

    public static String findExecutable(String named) {
        File file = new File(named);
        if (CommandLine.canExecute(file)) {
            return named;
        }
        Map<String, String> env = System.getenv();
        String pathName = "PATH";
        if (!env.containsKey("PATH")) {
            for (String key : env.keySet()) {
                if (!"path".equalsIgnoreCase(key)) continue;
                pathName = key;
                break;
            }
        }
        String path = env.get(pathName);
        String[] endings = new String[]{""};
        if (Platform.getCurrent().is(Platform.WINDOWS)) {
            endings = new String[]{"", ".exe", ".com", ".bat"};
        }
        for (String segment : path.split(File.pathSeparator)) {
            for (String ending : endings) {
                file = new File(segment, named + ending);
                if (!CommandLine.canExecute(file)) continue;
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    public void execute() {
        try {
            this.executed = true;
            ProcessBuilder builder = new ProcessBuilder(this.commandAndArgs);
            builder.redirectErrorStream(true);
            this.proc = builder.start();
            this.drainer = new StreamDrainer(this.proc);
            Thread thread = new Thread((Runnable)this.drainer, "Command line drainer: " + this.commandAndArgs[0]);
            thread.start();
            this.proc.waitFor();
            thread.join();
            this.exitCode = this.proc.exitValue();
        }
        catch (IOException e) {
            throw new WebDriverException(e);
        }
        catch (InterruptedException e) {
            throw new WebDriverException(e);
        }
    }

    public void executeAsync() {
        new Thread(){

            public void run() {
                CommandLine.this.execute();
            }
        }.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                if (CommandLine.this.proc != null) {
                    try {
                        CommandLine.this.proc.exitValue();
                    }
                    catch (IllegalThreadStateException e) {
                        CommandLine.this.proc.destroy();
                    }
                }
            }
        });
    }

    public boolean isSuccessful() {
        return 0 == this.getExitCode();
    }

    public int getExitCode() {
        if (!this.executed) {
            throw new IllegalStateException("Cannot get exit code before executing command line: " + this.commandAndArgs[0]);
        }
        return this.exitCode;
    }

    public String getStdOut() {
        if (!this.executed) {
            throw new IllegalStateException("Cannot get output before executing command line: " + this.commandAndArgs[0]);
        }
        return this.drainer.getStdOut();
    }

    public void destroy() {
        if (!this.executed) {
            throw new IllegalStateException("Cannot quit a process that's not running: " + this.commandAndArgs[0]);
        }
        this.proc.destroy();
    }

    private static boolean canExecute(File file) {
        if (JDK6_CAN_EXECUTE != null) {
            try {
                return (Boolean)JDK6_CAN_EXECUTE.invoke((Object)file, new Object[0]);
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return true;
    }

    private static Method findJdk6CanExecuteMethod() {
        try {
            return File.class.getMethod("setWritable", Boolean.class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static class StreamDrainer
    implements Runnable {
        private final Process toWatch;
        private ByteArrayOutputStream inputOut;

        StreamDrainer(Process toWatch) {
            this.toWatch = toWatch;
        }

        public void run() {
            BufferedInputStream inputStream = new BufferedInputStream(this.toWatch.getInputStream());
            this.inputOut = new ByteArrayOutputStream();
            byte[] buffer = new byte[2048];
            try {
                int read;
                while ((read = ((InputStream)inputStream).read(buffer)) > 0) {
                    this.inputOut.write(buffer, 0, read);
                    this.inputOut.flush();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    this.inputOut.close();
                }
                catch (IOException e) {}
            }
        }

        public String getStdOut() {
            return new String(this.inputOut.toByteArray());
        }
    }
}

