/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.reflect.internal;

import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.powermock.reflect.exceptions.ConstructorNotFoundException;
import org.powermock.reflect.exceptions.TooManyConstructorsFoundException;
import org.powermock.reflect.internal.Constructor;
import org.powermock.reflect.internal.WhiteboxImpl;

class ConstructorFinder {
    private Class<?> type;
    private Object[] arguments;
    private Class<?> unmockedType;
    private Constructor potentialConstructor;

    ConstructorFinder(Class<?> type, Object ... arguments) {
        if (type == null) {
            throw new IllegalArgumentException("Class type cannot be null.");
        }
        this.type = type;
        this.arguments = arguments;
        this.unmockedType = WhiteboxImpl.getOriginalUnmockedType(type);
        if (this.isNestedClass() && arguments != null) {
            this.addArgumentForNestedClass();
        }
    }

    public java.lang.reflect.Constructor findConstructor() {
        this.lookupPotentialConstructor();
        this.throwExceptionIfConstructorWasNotFound();
        return this.potentialConstructor.getJavaConstructor();
    }

    private void lookupPotentialConstructor() {
        Set<Constructor> constructors = this.getDeclaredConstructorsWithoutPowerMockConstructor();
        for (Constructor constructor : constructors) {
            if (constructor.canBeInvokeWith(this.arguments)) {
                this.setPotentialConstructor(constructor);
            }
            if (!this.isVarArgConstructorFound()) continue;
            return;
        }
    }

    private boolean isVarArgConstructorFound() {
        return this.potentialConstructor != null && this.potentialConstructor.isVarArg();
    }

    private void setPotentialConstructor(Constructor constructor) {
        if (this.potentialConstructor == null) {
            this.potentialConstructor = constructor;
        } else {
            this.throwExceptionWhenMultipleConstructorMatchesFound(new java.lang.reflect.Constructor[]{this.potentialConstructor.getJavaConstructor(), constructor.getJavaConstructor()});
        }
    }

    public void throwExceptionWhenMultipleConstructorMatchesFound(java.lang.reflect.Constructor[] constructors) {
        if (constructors == null || constructors.length < 2) {
            throw new IllegalArgumentException("Internal error: throwExceptionWhenMultipleConstructorMatchesFound needs at least two constructors.");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Several matching constructors found, please specify the argument parameter types so that PowerMock can determine which method you're referring to.\n");
        sb.append("Matching constructors in class ").append(constructors[0].getDeclaringClass().getName()).append(" were:\n");
        for (java.lang.reflect.Constructor constructor : constructors) {
            Class<?>[] parameterTypes;
            sb.append(constructor.getName()).append("( ");
            for (Class<?> paramType : parameterTypes = constructor.getParameterTypes()) {
                sb.append(paramType.getName()).append(".class ");
            }
            sb.append(")\n");
        }
        throw new TooManyConstructorsFoundException(sb.toString());
    }

    private void addArgumentForNestedClass() {
        Object[] argumentsForLocalClass = new Object[this.arguments.length + 1];
        argumentsForLocalClass[0] = this.unmockedType.getEnclosingClass();
        System.arraycopy(this.arguments, 0, argumentsForLocalClass, 1, this.arguments.length);
        this.arguments = argumentsForLocalClass;
    }

    private boolean isNestedClass() {
        return (this.unmockedType.isLocalClass() || this.unmockedType.isAnonymousClass() || this.unmockedType.isMemberClass()) && !Modifier.isStatic(this.unmockedType.getModifiers());
    }

    private Set<Constructor> getDeclaredConstructorsWithoutPowerMockConstructor() {
        HashSet<Constructor> constructors = new HashSet<Constructor>();
        for (java.lang.reflect.Constructor<?> constructor : this.unmockedType.getDeclaredConstructors()) {
            if (this.isPowerMockConstructor(constructor.getParameterTypes())) continue;
            constructors.add(new Constructor(constructor));
        }
        return constructors;
    }

    private boolean isPowerMockConstructor(Class<?>[] parameterTypes) {
        return parameterTypes.length >= 1 && parameterTypes[parameterTypes.length - 1].getName().equals("org.powermock.core.IndicateReloadClass");
    }

    private void throwExceptionIfConstructorWasNotFound() {
        if (this.potentialConstructor == null) {
            String message = "No constructor found in class '" + WhiteboxImpl.getOriginalUnmockedType(this.type).getName() + "' with parameter types: [ " + WhiteboxImpl.getArgumentTypesAsString(this.arguments) + " ].";
            throw new ConstructorNotFoundException(message);
        }
    }
}

