/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.ops4j.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import shaded.org.ops4j.lang.NullArgumentException;
import shaded.org.ops4j.net.AllCertificatesTrustManager;
import shaded.org.ops4j.net.Base64Encoder;

public class URLUtils {
    private URLUtils() {
    }

    public static URLConnection prepareForAuthentication(URLConnection connection) {
        NullArgumentException.validateNotNull(connection, "url connection cannot be null");
        if (connection.getURL().getUserInfo() != null) {
            String decodedUserInfo = URLUtils.decode(connection.getURL().getUserInfo());
            String base64Encoded = Base64Encoder.encode(decodedUserInfo);
            base64Encoded = base64Encoded.replaceAll("\n", "");
            connection.setRequestProperty("Authorization", "Basic " + base64Encoded);
        }
        return connection;
    }

    public static String decode(String url) {
        if (url == null) {
            return null;
        }
        StringBuilder decoded = new StringBuilder();
        int pos = 0;
        while (pos < url.length()) {
            char ch = url.charAt(pos);
            if (ch == '%') {
                if (pos + 2 < url.length()) {
                    String hexStr = url.substring(pos + 1, pos + 3);
                    char hexChar = (char)Integer.parseInt(hexStr, 16);
                    decoded.append(hexChar);
                    pos += 3;
                    continue;
                }
                throw new IllegalStateException("'%' escape must be followed by two hex digits");
            }
            decoded.append(ch);
            ++pos;
        }
        return decoded.toString();
    }

    public static URLConnection prepareForSSL(URLConnection connection) {
        NullArgumentException.validateNotNull(connection, "url connection cannot be null");
        URLConnection conn = connection;
        if (conn instanceof JarURLConnection) {
            try {
                conn = ((JarURLConnection)connection).getJarFileURL().openConnection();
                conn.connect();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not prepare connection for HTTPS.", e);
            }
        }
        if (conn instanceof HttpsURLConnection) {
            try {
                SSLContext ctx = SSLContext.getInstance("SSLv3");
                ctx.init(null, new TrustManager[]{new AllCertificatesTrustManager()}, null);
                ((HttpsURLConnection)conn).setSSLSocketFactory(ctx.getSocketFactory());
            }
            catch (KeyManagementException e) {
                throw new RuntimeException("Could not prepare connection for HTTPS.", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Could not prepare connection for HTTPS.", e);
            }
        }
        return connection;
    }

    public static InputStream prepareInputStream(URL url, boolean acceptAnyCertificate) throws IOException {
        URLConnection conn = url.openConnection();
        URLUtils.prepareForAuthentication(conn);
        URLUtils.prepareHttpHeaders(conn);
        if (acceptAnyCertificate) {
            URLUtils.prepareForSSL(conn);
        }
        return conn.getInputStream();
    }

    private static void prepareHttpHeaders(URLConnection conn) {
        if (conn instanceof HttpURLConnection) {
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
        }
    }
}

