/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rolling.helper;

import java.io.IOException;
import java.util.List;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.rolling.helper.Action;
import org.apache.log4j.rolling.helper.ActionBase;

public class CompositeAction
extends ActionBase {
    private final Action[] actions;
    private final boolean stopOnError;

    public CompositeAction(List actions, boolean stopOnError) {
        this.actions = new Action[actions.size()];
        actions.toArray(this.actions);
        this.stopOnError = stopOnError;
    }

    @Override
    public void run() {
        try {
            this.execute();
        }
        catch (IOException ex) {
            LogLog.warn("Exception during file rollover.", ex);
        }
    }

    @Override
    public boolean execute() throws IOException {
        if (this.stopOnError) {
            for (int i = 0; i < this.actions.length; ++i) {
                if (this.actions[i].execute()) continue;
                return false;
            }
            return true;
        }
        boolean status = true;
        IOException exception = null;
        for (int i = 0; i < this.actions.length; ++i) {
            try {
                status &= this.actions[i].execute();
                continue;
            }
            catch (IOException ex) {
                status = false;
                if (exception != null) continue;
                exception = ex;
            }
        }
        if (exception != null) {
            throw exception;
        }
        return status;
    }
}

