/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.helpers;

import info.aduna.concurrent.locks.Lock;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.AccessControlException;
import org.openrdf.sail.LockManager;
import org.openrdf.sail.SailLockedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryLockManager
implements LockManager {
    private static final String LOCK_DIR_NAME = "lock";
    private static final String LOCK_FILE_NAME = "locked";
    private static final String INFO_FILE_NAME = "process";
    private final Logger logger = LoggerFactory.getLogger(DirectoryLockManager.class);
    private final File dir;

    public DirectoryLockManager(File dir) {
        this.dir = dir;
    }

    @Override
    public String getLocation() {
        return this.dir.toString();
    }

    private File getLockDir() {
        return new File(this.dir, LOCK_DIR_NAME);
    }

    @Override
    public boolean isLocked() {
        return this.getLockDir().exists();
    }

    @Override
    public Lock tryLock() {
        File lockDir = this.getLockDir();
        if (lockDir.exists()) {
            this.removeInvalidLock(lockDir);
        }
        if (!lockDir.mkdir()) {
            return null;
        }
        Lock lock = null;
        try {
            File infoFile = new File(lockDir, INFO_FILE_NAME);
            File lockedFile = new File(lockDir, LOCK_FILE_NAME);
            RandomAccessFile raf = new RandomAccessFile(lockedFile, "rw");
            try {
                FileLock fileLock = raf.getChannel().lock();
                lock = this.createLock(raf, fileLock);
                this.sign(infoFile);
            }
            catch (IOException e) {
                if (lock != null) {
                    lock.release();
                } else {
                    raf.close();
                }
                throw e;
            }
        }
        catch (IOException e) {
            this.logger.error(e.toString(), (Throwable)e);
        }
        return lock;
    }

    @Override
    public Lock lockOrFail() throws SailLockedException {
        Lock lock = this.tryLock();
        if (lock != null) {
            return lock;
        }
        String requestedBy = this.getProcessName();
        String lockedBy = this.getLockedBy();
        if (lockedBy != null) {
            throw new SailLockedException(lockedBy, requestedBy, this);
        }
        lock = this.tryLock();
        if (lock != null) {
            return lock;
        }
        throw new SailLockedException(requestedBy);
    }

    @Override
    public boolean revokeLock() {
        File lockDir = this.getLockDir();
        File lockedFile = new File(lockDir, LOCK_FILE_NAME);
        File infoFile = new File(lockDir, INFO_FILE_NAME);
        lockedFile.delete();
        infoFile.delete();
        return lockDir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInvalidLock(File lockDir) {
        try {
            boolean revokeLock = false;
            File lockedFile = new File(lockDir, LOCK_FILE_NAME);
            RandomAccessFile raf = new RandomAccessFile(lockedFile, "rw");
            try {
                FileLock fileLock = raf.getChannel().tryLock();
                if (fileLock != null) {
                    this.logger.warn("Removing invalid lock {}", (Object)this.getLockedBy());
                    fileLock.release();
                    revokeLock = true;
                }
            }
            catch (OverlappingFileLockException exc) {
            }
            finally {
                raf.close();
            }
            if (revokeLock) {
                this.revokeLock();
            }
        }
        catch (IOException e) {
            this.logger.warn(e.toString(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLockedBy() {
        String string;
        File lockDir = this.getLockDir();
        File infoFile = new File(lockDir, INFO_FILE_NAME);
        BufferedReader reader = new BufferedReader(new FileReader(infoFile));
        try {
            string = reader.readLine();
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e) {
                this.logger.warn(e.toString(), (Throwable)e);
                return null;
            }
        }
        reader.close();
        return string;
    }

    private Lock createLock(final RandomAccessFile raf, final FileLock fileLock) {
        return new Lock(){
            private boolean active = true;
            private Thread hook;
            {
                try {
                    Thread hook = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            this.delete();
                        }
                    });
                    Runtime.getRuntime().addShutdownHook(hook);
                    this.hook = hook;
                }
                catch (AccessControlException e) {
                    // empty catch block
                }
            }

            @Override
            public boolean isActive() {
                return this.active;
            }

            @Override
            public void release() {
                this.active = false;
                try {
                    if (this.hook != null) {
                        Runtime.getRuntime().removeShutdownHook(this.hook);
                    }
                }
                catch (IllegalStateException e) {
                }
                catch (AccessControlException e) {
                    DirectoryLockManager.this.logger.warn(e.toString(), (Throwable)e);
                }
                this.delete();
            }

            void delete() {
                try {
                    fileLock.release();
                    raf.close();
                }
                catch (ClosedChannelException e) {
                }
                catch (IOException e) {
                    DirectoryLockManager.this.logger.warn(e.toString(), (Throwable)e);
                }
                DirectoryLockManager.this.revokeLock();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sign(File infoFile) throws IOException {
        FileWriter out = new FileWriter(infoFile);
        try {
            out.write(this.getProcessName());
            out.flush();
        }
        finally {
            out.close();
        }
    }

    private String getProcessName() {
        return ManagementFactory.getRuntimeMXBean().getName();
    }
}

