/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.resultio.sparqlxml;

import info.aduna.xml.XMLWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultWriter;

public class SPARQLResultsXMLWriter
implements TupleQueryResultWriter {
    private XMLWriter xmlWriter;

    public SPARQLResultsXMLWriter(OutputStream out) {
        this(new XMLWriter(out));
    }

    public SPARQLResultsXMLWriter(XMLWriter xmlWriter) {
        this.xmlWriter = xmlWriter;
        this.xmlWriter.setPrettyPrint(true);
    }

    public final TupleQueryResultFormat getTupleQueryResultFormat() {
        return TupleQueryResultFormat.SPARQL;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.xmlWriter.setPrettyPrint(prettyPrint);
    }

    public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
        try {
            this.xmlWriter.startDocument();
            this.xmlWriter.setAttribute("xmlns", "http://www.w3.org/2005/sparql-results#");
            this.xmlWriter.startTag("sparql");
            this.xmlWriter.startTag("head");
            for (String name : bindingNames) {
                this.xmlWriter.setAttribute("name", name);
                this.xmlWriter.emptyElement("variable");
            }
            this.xmlWriter.endTag("head");
            this.xmlWriter.startTag("results");
        }
        catch (IOException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    public void endQueryResult() throws TupleQueryResultHandlerException {
        try {
            this.xmlWriter.endTag("results");
            this.xmlWriter.endTag("sparql");
            this.xmlWriter.endDocument();
        }
        catch (IOException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    public void handleSolution(BindingSet bindingSet) throws TupleQueryResultHandlerException {
        try {
            this.xmlWriter.startTag("result");
            for (Binding binding : bindingSet) {
                this.xmlWriter.setAttribute("name", binding.getName());
                this.xmlWriter.startTag("binding");
                this.writeValue(binding.getValue());
                this.xmlWriter.endTag("binding");
            }
            this.xmlWriter.endTag("result");
        }
        catch (IOException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    private void writeValue(Value value) throws IOException {
        if (value instanceof URI) {
            this.writeURI((URI)value);
        } else if (value instanceof BNode) {
            this.writeBNode((BNode)value);
        } else if (value instanceof Literal) {
            this.writeLiteral((Literal)value);
        }
    }

    private void writeURI(URI uri) throws IOException {
        this.xmlWriter.textElement("uri", uri.toString());
    }

    private void writeBNode(BNode bNode) throws IOException {
        this.xmlWriter.textElement("bnode", bNode.getID());
    }

    private void writeLiteral(Literal literal) throws IOException {
        if (literal.getLanguage() != null) {
            this.xmlWriter.setAttribute("xml:lang", literal.getLanguage());
        } else if (literal.getDatatype() != null) {
            URI datatype = literal.getDatatype();
            this.xmlWriter.setAttribute("datatype", datatype.toString());
        }
        this.xmlWriter.textElement("literal", literal.getLabel());
    }
}

