/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.resultio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryResults;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.impl.TupleQueryResultBuilder;
import org.openrdf.query.resultio.BooleanQueryResultFormat;
import org.openrdf.query.resultio.BooleanQueryResultParser;
import org.openrdf.query.resultio.BooleanQueryResultParserFactory;
import org.openrdf.query.resultio.BooleanQueryResultParserRegistry;
import org.openrdf.query.resultio.BooleanQueryResultWriter;
import org.openrdf.query.resultio.BooleanQueryResultWriterFactory;
import org.openrdf.query.resultio.BooleanQueryResultWriterRegistry;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultParser;
import org.openrdf.query.resultio.TupleQueryResultParserFactory;
import org.openrdf.query.resultio.TupleQueryResultParserRegistry;
import org.openrdf.query.resultio.TupleQueryResultWriter;
import org.openrdf.query.resultio.TupleQueryResultWriterFactory;
import org.openrdf.query.resultio.TupleQueryResultWriterRegistry;
import org.openrdf.query.resultio.UnsupportedQueryResultFormatException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.Rio;
import org.openrdf.rio.UnsupportedRDFormatException;

public class QueryResultIO {
    public static TupleQueryResultFormat getParserFormatForMIMEType(String mimeType) {
        return (TupleQueryResultFormat)TupleQueryResultParserRegistry.getInstance().getFileFormatForMIMEType(mimeType, null);
    }

    public static TupleQueryResultFormat getParserFormatForMIMEType(String mimeType, TupleQueryResultFormat fallback) {
        return (TupleQueryResultFormat)TupleQueryResultParserRegistry.getInstance().getFileFormatForMIMEType(mimeType, fallback);
    }

    public static TupleQueryResultFormat getParserFormatForFileName(String fileName) {
        return (TupleQueryResultFormat)TupleQueryResultParserRegistry.getInstance().getFileFormatForFileName(fileName);
    }

    public static TupleQueryResultFormat getParserFormatForFileName(String fileName, TupleQueryResultFormat fallback) {
        return (TupleQueryResultFormat)TupleQueryResultParserRegistry.getInstance().getFileFormatForFileName(fileName, fallback);
    }

    public static TupleQueryResultFormat getWriterFormatForMIMEType(String mimeType) {
        return (TupleQueryResultFormat)TupleQueryResultWriterRegistry.getInstance().getFileFormatForMIMEType(mimeType);
    }

    public static TupleQueryResultFormat getWriterFormatForMIMEType(String mimeType, TupleQueryResultFormat fallback) {
        return (TupleQueryResultFormat)TupleQueryResultWriterRegistry.getInstance().getFileFormatForMIMEType(mimeType, fallback);
    }

    public static TupleQueryResultFormat getWriterFormatForFileName(String fileName) {
        return (TupleQueryResultFormat)TupleQueryResultWriterRegistry.getInstance().getFileFormatForFileName(fileName);
    }

    public static TupleQueryResultFormat getWriterFormatForFileName(String fileName, TupleQueryResultFormat fallback) {
        return (TupleQueryResultFormat)TupleQueryResultWriterRegistry.getInstance().getFileFormatForFileName(fileName, fallback);
    }

    public static TupleQueryResultParser createParser(TupleQueryResultFormat format) throws UnsupportedQueryResultFormatException {
        TupleQueryResultParserFactory factory = (TupleQueryResultParserFactory)TupleQueryResultParserRegistry.getInstance().get((Object)format);
        if (factory != null) {
            return factory.getParser();
        }
        throw new UnsupportedQueryResultFormatException("No parser factory available for tuple query result format " + (Object)((Object)format));
    }

    public static TupleQueryResultParser createParser(TupleQueryResultFormat format, ValueFactory valueFactory) throws UnsupportedQueryResultFormatException {
        TupleQueryResultParser parser = QueryResultIO.createParser(format);
        parser.setValueFactory(valueFactory);
        return parser;
    }

    public static TupleQueryResultWriter createWriter(TupleQueryResultFormat format, OutputStream out) throws UnsupportedQueryResultFormatException {
        TupleQueryResultWriterFactory factory = (TupleQueryResultWriterFactory)TupleQueryResultWriterRegistry.getInstance().get((Object)format);
        if (factory != null) {
            return factory.getWriter(out);
        }
        throw new UnsupportedQueryResultFormatException("No writer factory available for tuple query result format " + (Object)((Object)format));
    }

    public static BooleanQueryResultParser createParser(BooleanQueryResultFormat format) throws UnsupportedQueryResultFormatException {
        BooleanQueryResultParserFactory factory = (BooleanQueryResultParserFactory)BooleanQueryResultParserRegistry.getInstance().get((Object)format);
        if (factory != null) {
            return factory.getParser();
        }
        throw new UnsupportedQueryResultFormatException("No parser factory available for boolean query result format " + (Object)((Object)format));
    }

    public static BooleanQueryResultWriter createWriter(BooleanQueryResultFormat format, OutputStream out) throws UnsupportedQueryResultFormatException {
        BooleanQueryResultWriterFactory factory = (BooleanQueryResultWriterFactory)BooleanQueryResultWriterRegistry.getInstance().get((Object)format);
        if (factory != null) {
            return factory.getWriter(out);
        }
        throw new UnsupportedQueryResultFormatException("No writer factory available for boolean query result format " + (Object)((Object)format));
    }

    public static void parse(InputStream in, TupleQueryResultFormat format, TupleQueryResultHandler handler, ValueFactory valueFactory) throws IOException, QueryResultParseException, TupleQueryResultHandlerException, UnsupportedQueryResultFormatException {
        TupleQueryResultParser parser = QueryResultIO.createParser(format);
        parser.setValueFactory(valueFactory);
        parser.setTupleQueryResultHandler(handler);
        parser.parse(in);
    }

    public static TupleQueryResult parse(InputStream in, TupleQueryResultFormat format) throws IOException, QueryResultParseException, TupleQueryResultHandlerException, UnsupportedQueryResultFormatException {
        TupleQueryResultParser parser = QueryResultIO.createParser(format);
        TupleQueryResultBuilder qrBuilder = new TupleQueryResultBuilder();
        parser.setTupleQueryResultHandler((TupleQueryResultHandler)qrBuilder);
        parser.parse(in);
        return qrBuilder.getQueryResult();
    }

    public static boolean parse(InputStream in, BooleanQueryResultFormat format) throws IOException, QueryResultParseException, UnsupportedQueryResultFormatException {
        BooleanQueryResultParser parser = QueryResultIO.createParser(format);
        return parser.parse(in);
    }

    public static void write(TupleQueryResult tqr, TupleQueryResultFormat format, OutputStream out) throws IOException, TupleQueryResultHandlerException, UnsupportedQueryResultFormatException, QueryEvaluationException {
        TupleQueryResultWriter writer = QueryResultIO.createWriter(format, out);
        try {
            QueryResults.report((TupleQueryResult)tqr, (TupleQueryResultHandler)writer);
        }
        catch (TupleQueryResultHandlerException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    public static void write(boolean value, BooleanQueryResultFormat format, OutputStream out) throws IOException, UnsupportedQueryResultFormatException {
        BooleanQueryResultWriter writer = QueryResultIO.createWriter(format, out);
        writer.write(value);
    }

    public static void write(GraphQueryResult gqr, RDFFormat format, OutputStream out) throws IOException, RDFHandlerException, UnsupportedRDFormatException, QueryEvaluationException {
        RDFWriter writer = Rio.createWriter((RDFFormat)format, (OutputStream)out);
        try {
            QueryResults.report((GraphQueryResult)gqr, (RDFHandler)writer);
        }
        catch (RDFHandlerException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }
}

