/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.federation;

import info.aduna.iteration.CloseableIteration;
import java.util.Collection;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.Service;
import org.openrdf.query.algebra.evaluation.federation.FederatedService;
import org.openrdf.query.algebra.evaluation.federation.JoinExecutorBase;
import org.openrdf.query.algebra.evaluation.iterator.SilentIteration;
import org.openrdf.query.impl.EmptyBindingSet;

public class ServiceFallbackIteration
extends JoinExecutorBase<BindingSet> {
    protected final Service service;
    protected final String preparedQuery;
    protected final FederatedService federatedService;
    protected final Collection<BindingSet> bindings;

    public ServiceFallbackIteration(Service service, String preparedQuery, Collection<BindingSet> bindings, FederatedService federatedService) throws QueryEvaluationException {
        super(null, null, EmptyBindingSet.getInstance());
        this.service = service;
        this.preparedQuery = preparedQuery;
        this.bindings = bindings;
        this.federatedService = federatedService;
        this.run();
    }

    @Override
    protected void handleBindings() throws Exception {
        for (BindingSet b : this.bindings) {
            CloseableIteration<BindingSet, QueryEvaluationException> result = this.federatedService.evaluate(this.preparedQuery, b, this.service.getBaseURI(), FederatedService.QueryType.SELECT, this.service);
            result = this.service.isSilent() ? new SilentIteration(result) : result;
            this.addResult(result);
        }
    }
}

