/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.weixin.impl;

import java.io.Reader;
import java.util.Map;
import org.nutz.http.Request;
import org.nutz.http.Response;
import org.nutz.http.Sender;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.json.Json;
import org.nutz.lang.Strings;
import org.nutz.lang.util.NutMap;
import org.nutz.weixin.spi.WxLogin;
import org.nutz.weixin.spi.WxResp;

public class WxLoginImpl
implements WxLogin {
    protected String host;
    protected String appid;
    protected String appsecret;

    @Override
    public String qrconnect(String redirect_uri, String scope, String state) {
        Request req = Request.create((String)"https://open.weixin.qq.com/connect/qrconnect", (Request.METHOD)Request.METHOD.GET);
        NutMap params = new NutMap();
        params.put((Object)"appid", (Object)this.appid);
        if (redirect_uri.startsWith("http")) {
            params.put((Object)"redirect_uri", (Object)redirect_uri);
        } else {
            params.put((Object)"redirect_uri", (Object)(this.host + redirect_uri));
        }
        params.put((Object)"response_type", (Object)"code");
        params.put((Object)"scope", (Object)Strings.sBlank((Object)scope, (String)"snsapi_login"));
        req.setParams((Map)params);
        return req.getUrl().toString() + "#wechat_redirect";
    }

    @Override
    public String authorize(String redirect_uri, String scope, String state) {
        Request req = Request.create((String)"https://open.weixin.qq.com/connect/oauth2/authorize", (Request.METHOD)Request.METHOD.GET);
        NutMap params = new NutMap();
        params.put((Object)"appid", (Object)this.appid);
        if (redirect_uri.startsWith("http")) {
            params.put((Object)"redirect_uri", (Object)redirect_uri);
        } else {
            params.put((Object)"redirect_uri", (Object)(this.host + redirect_uri));
        }
        params.put((Object)"response_type", (Object)"code");
        params.put((Object)"scope", (Object)Strings.sBlank((Object)scope, (String)"snsapi_userinfo"));
        req.setParams((Map)params);
        return req.getUrl().toString() + "#wechat_redirect";
    }

    @Override
    public WxResp access_token(String code) {
        Request req = Request.create((String)"https://api.weixin.qq.com/sns/oauth2/access_token", (Request.METHOD)Request.METHOD.GET);
        NutMap params = new NutMap();
        params.put((Object)"appid", (Object)this.appid);
        params.put((Object)"secret", (Object)this.appsecret);
        params.put((Object)"code", (Object)code);
        params.put((Object)"grant_type", (Object)"authorization_code");
        req.setParams((Map)params);
        Response resp = Sender.create((Request)req).send();
        if (!resp.isOK()) {
            return null;
        }
        return (WxResp)((Object)Json.fromJson(WxResp.class, (Reader)resp.getReader("UTF-8")));
    }

    @Override
    public WxResp refresh_token(String refresh_token) {
        Request req = Request.create((String)"https://api.weixin.qq.com/sns/oauth2/refresh_token", (Request.METHOD)Request.METHOD.GET);
        NutMap params = new NutMap();
        params.put((Object)"appid", (Object)this.appid);
        params.put((Object)"secret", (Object)this.appsecret);
        params.put((Object)"refresh_token", (Object)refresh_token);
        params.put((Object)"grant_type", (Object)"refresh_token");
        req.setParams((Map)params);
        Response resp = Sender.create((Request)req).send();
        if (!resp.isOK()) {
            return null;
        }
        return (WxResp)((Object)Json.fromJson(WxResp.class, (Reader)resp.getReader("UTF-8")));
    }

    @Override
    public WxResp auth(String token) {
        return null;
    }

    @Override
    public WxResp userinfo(String openid, String access_token) {
        Request req = Request.create((String)"https://api.weixin.qq.com/sns/userinfo", (Request.METHOD)Request.METHOD.GET);
        NutMap params = new NutMap();
        params.put((Object)"access_token", (Object)access_token);
        params.put((Object)"openid", (Object)openid);
        req.setParams((Map)params);
        Response resp = Sender.create((Request)req).send();
        if (!resp.isOK()) {
            return null;
        }
        return (WxResp)((Object)Json.fromJson(WxResp.class, (Reader)resp.getReader("UTF-8")));
    }

    public WxLoginImpl configure(PropertiesProxy conf, String prefix) {
        prefix = Strings.sBlank((Object)prefix);
        this.appid = conf.get(prefix + "appid");
        this.appsecret = conf.get(prefix + "appsecret");
        this.host = conf.get(prefix + "host");
        return this;
    }
}

