/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.weixin.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nutz.http.Http;
import org.nutz.http.Request;
import org.nutz.http.Response;
import org.nutz.http.Sender;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.json.Json;
import org.nutz.lang.Encoding;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.lang.random.R;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.weixin.WxException;
import org.nutz.weixin.at.WxAccessToken;
import org.nutz.weixin.at.WxJsapiTicket;
import org.nutz.weixin.at.impl.MemoryAccessTokenStore;
import org.nutz.weixin.at.impl.MemoryJsapiTicketStore;
import org.nutz.weixin.bean.WxInMsg;
import org.nutz.weixin.bean.WxOutMsg;
import org.nutz.weixin.repo.com.qq.weixin.mp.aes.AesException;
import org.nutz.weixin.repo.com.qq.weixin.mp.aes.WXBizMsgCrypt;
import org.nutz.weixin.spi.WxAccessTokenStore;
import org.nutz.weixin.spi.WxApi2;
import org.nutz.weixin.spi.WxHandler;
import org.nutz.weixin.spi.WxJsapiTicketStore;
import org.nutz.weixin.spi.WxResp;
import org.nutz.weixin.util.BeanConfigures;
import org.nutz.weixin.util.Wxs;

public abstract class AbstractWxApi2
implements WxApi2 {
    private static final Log log = Logs.get();
    protected String token;
    protected String appid;
    protected String appsecret;
    protected String base = "https://api.weixin.qq.com/cgi-bin";
    protected String openid;
    protected String encodingAesKey;
    protected int retryTimes = 3;
    protected PropertiesProxy conf;
    protected String confKeyPrefix = "weixin.";
    protected Object lock = new Object();
    protected WXBizMsgCrypt pc;
    protected WxAccessTokenStore accessTokenStore = new MemoryAccessTokenStore();
    protected WxJsapiTicketStore jsapiTicketStore = new MemoryJsapiTicketStore();

    public AbstractWxApi2(String token, String appid, String appsecret, String openid, String encodingAesKey) {
        this();
        this.token = token;
        this.appid = appid;
        this.appsecret = appsecret;
        this.openid = openid;
        this.encodingAesKey = encodingAesKey;
    }

    public void init() {
        this.configure(this.conf, this.confKeyPrefix);
    }

    public WxApi2 configure(PropertiesProxy conf, String prefix) {
        prefix = Strings.sBlank((Object)prefix);
        this.token = conf.check(prefix + "token");
        this.appid = conf.get(prefix + "appid");
        this.appsecret = conf.get(prefix + "appsecret");
        this.openid = conf.get(prefix + "openid");
        this.encodingAesKey = conf.get(prefix + "aes");
        return this;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getAppid() {
        return this.appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getAppsecret() {
        return this.appsecret;
    }

    public void setAppsecret(String appsecret) {
        this.appsecret = appsecret;
    }

    public String getOpenid() {
        return this.openid;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public String getEncodingAesKey() {
        return this.encodingAesKey;
    }

    public void setEncodingAesKey(String encodingAesKey) {
        this.encodingAesKey = encodingAesKey;
    }

    public AbstractWxApi2() {
    }

    @Override
    public WxAccessTokenStore getAccessTokenStore() {
        return this.accessTokenStore;
    }

    @Override
    public void setAccessTokenStore(WxAccessTokenStore ats) {
        this.accessTokenStore = ats;
    }

    @Override
    public WxJsapiTicketStore getJsapiTicketStore() {
        return this.jsapiTicketStore;
    }

    @Override
    public void setJsapiTicketStore(WxJsapiTicketStore jsapiTicketStore) {
        this.jsapiTicketStore = jsapiTicketStore;
    }

    protected synchronized void checkWXBizMsgCrypt() {
        if (this.pc != null || this.encodingAesKey == null || this.token == null || this.appid == null) {
            return;
        }
        try {
            this.pc = new WXBizMsgCrypt(this.token, this.encodingAesKey, this.appid);
        }
        catch (AesException e) {
            throw new WxException(e);
        }
    }

    @Override
    public WxInMsg parse(HttpServletRequest req) {
        ServletInputStream in;
        try {
            in = req.getInputStream();
        }
        catch (IOException e) {
            throw new WxException(e);
        }
        String encrypt_type = req.getParameter("encrypt_type");
        if (encrypt_type == null || "raw".equals(encrypt_type)) {
            return Wxs.convert((InputStream)in);
        }
        this.checkWXBizMsgCrypt();
        if (this.pc == null) {
            throw new WxException("encrypt message, but not configure token/encodingAesKey/appid");
        }
        try {
            String msg_signature = req.getParameter("msg_signature");
            String timestamp = req.getParameter("timestamp");
            String nonce = req.getParameter("nonce");
            String str = this.pc.decryptMsg(msg_signature, timestamp, nonce, new String(Streams.readBytesAndClose((InputStream)in), Encoding.CHARSET_UTF8));
            return Wxs.convert(str);
        }
        catch (AesException e) {
            throw new WxException("bad message or bad encodingAesKey", e);
        }
    }

    @Override
    public void handle(HttpServletRequest req, HttpServletResponse resp, WxHandler handler) {
        try {
            WxInMsg in = this.parse(req);
            WxOutMsg out = handler.handle(in);
            StringWriter sw = new StringWriter();
            Wxs.asXml(sw, out);
            String re = sw.getBuffer().toString();
            if (this.pc != null) {
                re = this.pc.encryptMsg(re, req.getParameter("timestamp"), req.getParameter("nonce"));
            }
            resp.getWriter().write(re);
        }
        catch (AesException e) {
            throw new WxException(e);
        }
        catch (IOException e) {
            throw new WxException(e);
        }
    }

    protected WxResp get(String uri, String ... args) {
        String params = "";
        for (int i = 0; i < args.length; i += 2) {
            if (args[i + 1] == null) continue;
            params = params + "&" + args[i] + "=" + args[i + 1];
        }
        return this.call(uri + "?_=1&" + params, Request.METHOD.GET, null);
    }

    protected WxResp postJson(String uri, Object ... args) {
        NutMap body = new NutMap();
        for (int i = 0; i < args.length; i += 2) {
            body.put((Object)args[i].toString(), args[i + 1]);
        }
        return this.postJson(uri, body);
    }

    protected WxResp postJson(String uri, NutMap body) {
        return this.call(uri, Request.METHOD.POST, Json.toJson((Object)body));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WxResp call(String URL2, Request.METHOD method, String body) {
        String token = this.getAccessToken();
        if (log.isInfoEnabled()) {
            log.info((Object)("wxapi call: " + URL2));
            if (log.isDebugEnabled()) {
                log.debug((Object)body);
            }
        }
        int retry = this.retryTimes;
        WxResp wxResp = null;
        while (retry >= 0) {
            try {
                Response resp;
                String sendUrl = null;
                if (!URL2.startsWith("http")) {
                    sendUrl = this.base + URL2;
                }
                sendUrl = URL2.contains("?") ? sendUrl + "&access_token=" + token : sendUrl + "?access_token=" + token;
                Request req = Request.create((String)sendUrl, (Request.METHOD)method);
                if (body != null) {
                    req.setData(body);
                }
                if (!(resp = Sender.create((Request)req).send()).isOK()) {
                    throw new IllegalArgumentException("resp code=" + resp.getStatus());
                }
                wxResp = (WxResp)((Object)Json.fromJson(WxResp.class, (Reader)resp.getReader("UTF-8")));
                if (wxResp.errcode() != 40001) break;
                log.warnf("wxapi of access_token request [%s] finished, but the return code is 40001, try to reflush access_token right now, surplus retry times : %s", new Object[]{URL2, retry});
                this.reflushAccessToken();
            }
            catch (Exception e) {
                if (this.retryTimes >= 0) {
                    log.warn((Object)("reflushing access_token... " + retry + " retries left."), (Throwable)e);
                    continue;
                }
                log.errorf("%s times attempts to get a wx access_token , but all failed!", new Object[]{this.retryTimes});
                throw Lang.wrapThrow((Throwable)e);
            }
            finally {
                --retry;
            }
        }
        return wxResp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJsapiTicket() {
        WxJsapiTicket at = this.jsapiTicketStore.get();
        if (at == null || (long)at.getExpires() < (System.currentTimeMillis() - at.getLastCacheTimeMillis()) / 1000L) {
            Object object = this.lock;
            synchronized (object) {
                WxJsapiTicket at_forupdate = this.jsapiTicketStore.get();
                if (at_forupdate == null || (long)at_forupdate.getExpires() < (System.currentTimeMillis() - at_forupdate.getLastCacheTimeMillis()) / 1000L) {
                    this.reflushJsapiTicket();
                }
            }
        }
        return this.jsapiTicketStore.get().getTicket();
    }

    protected void reflushJsapiTicket() {
        Response resp;
        String at = this.getAccessToken();
        String url = String.format("%s/ticket/getticket?access_token=%s&type=jsapi", this.base, at);
        if (log.isDebugEnabled()) {
            log.debugf("ATS: reflush jsapi ticket send: %s", new Object[]{url});
        }
        if (!(resp = Http.get((String)url)).isOK()) {
            throw new IllegalArgumentException("reflushJsapiTicket FAIL , openid=" + this.openid);
        }
        String str = resp.getContent();
        if (log.isDebugEnabled()) {
            log.debugf("ATS: reflush jsapi ticket done: %s", new Object[]{str});
        }
        NutMap re = (NutMap)Json.fromJson(NutMap.class, (CharSequence)str);
        String ticket = re.getString("ticket");
        int expires = re.getInt("expires_in") - 200;
        this.jsapiTicketStore.save(ticket, expires, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAccessToken() {
        WxAccessToken at = this.accessTokenStore.get();
        if (at == null || (long)at.getExpires() < (System.currentTimeMillis() - at.getLastCacheTimeMillis()) / 1000L) {
            Object object = this.lock;
            synchronized (object) {
                WxAccessToken at_forupdate = this.accessTokenStore.get();
                if (at_forupdate == null || (long)at_forupdate.getExpires() < (System.currentTimeMillis() - at_forupdate.getLastCacheTimeMillis()) / 1000L) {
                    this.reflushAccessToken();
                }
            }
        }
        return this.accessTokenStore.get().getToken();
    }

    protected synchronized void reflushAccessToken() {
        Response resp;
        String url = String.format("%s/token?grant_type=client_credential&appid=%s&secret=%s", this.base, this.appid, this.appsecret);
        if (log.isDebugEnabled()) {
            log.debugf("ATS: reflush access_token send: %s", new Object[]{url});
        }
        if (!(resp = Http.get((String)url)).isOK()) {
            throw new IllegalArgumentException("reflushAccessToken FAIL , openid=" + this.openid);
        }
        String str = resp.getContent();
        if (log.isDebugEnabled()) {
            log.debugf("ATS: reflush access_token done: %s", new Object[]{str});
        }
        NutMap re = (NutMap)Json.fromJson(NutMap.class, (CharSequence)str);
        String token = re.getString("access_token");
        int expires = re.getInt("expires_in") - 200;
        this.accessTokenStore.save(token, expires, System.currentTimeMillis());
    }

    @Override
    public NutMap genJsSDKConfig(String url, String ... jsApiList) {
        String jt = this.getJsapiTicket();
        long timestamp = System.currentTimeMillis();
        String nonceStr = R.UU64();
        String str = String.format("jsapi_ticket=%s&noncestr=%s&timestamp=%d&url=%s", jt, nonceStr, timestamp, url);
        String signature = Lang.sha1((CharSequence)str);
        NutMap map = new NutMap();
        map.put((Object)"appId", (Object)this.appid);
        map.put((Object)"timestamp", (Object)timestamp);
        map.put((Object)"nonceStr", (Object)nonceStr);
        map.put((Object)"signature", (Object)signature);
        map.put((Object)"jsApiList", (Object)jsApiList);
        return map;
    }

    public void configure(Object obj) {
        BeanConfigures.configure(this, obj);
    }
}

