/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.spring;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.regex.Pattern;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.lang.Strings;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractGenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class NutzJsonMessageConverter
extends AbstractGenericHttpMessageConverter<Object> {
    JsonFormat format = JsonFormat.compact();
    Pattern ignoreType;

    public NutzJsonMessageConverter setIgnoreType(String ignoreType) {
        if (Strings.isBlank((CharSequence)ignoreType)) {
            return this;
        }
        this.ignoreType = Pattern.compile(ignoreType);
        return this;
    }

    public NutzJsonMessageConverter setFormat(JsonFormat format) {
        this.format = format;
        return this;
    }

    public NutzJsonMessageConverter() {
        super(new MediaType[]{MediaType.APPLICATION_JSON, MediaType.APPLICATION_JSON_UTF8, new MediaType("application", "*+json")});
    }

    public Object read(Type type, Class<?> contextClass, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        return Json.fromJson((Type)type, (Reader)new InputStreamReader(inputMessage.getBody()));
    }

    protected void writeInternal(Object t, Type type, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        Json.toJson((Writer)new OutputStreamWriter(outputMessage.getBody()), (Object)t, (JsonFormat)this.format);
    }

    protected boolean supports(Class<?> clazz) {
        return true;
    }

    public boolean canWrite(Type type, Class<?> clazz, MediaType mediaType) {
        if (Pattern.matches(".*springfox.*", clazz.getName())) {
            return false;
        }
        if (Pattern.matches("org.springframework.*", clazz.getName())) {
            return false;
        }
        return this.ignoreType == null || !this.ignoreType.matcher(clazz.getName()).matches();
    }

    protected Object readInternal(Class<? extends Object> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        return Json.fromJson(clazz, (Reader)new InputStreamReader(inputMessage.getBody()));
    }
}

