/*
 * Decompiled with CFR 0.152.
 */
package ninja.utils;

import java.util.Properties;
import ninja.utils.NinjaProperties;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.junit.Assert;

public class MockNinjaProperties
implements NinjaProperties {
    private String contextPath;
    private final String mode;
    private final Configuration configuration;

    public static MockNinjaProperties create(String ... args) {
        return MockNinjaProperties.createWithMode("test", null, args);
    }

    public static MockNinjaProperties createWithMode(String mode, String contextPath, String ... args) {
        Assert.assertTrue((String)"You must supply an even number of arguments to form key value pairs", (args.length % 2 == 0 ? 1 : 0) != 0);
        PropertiesConfiguration props = new PropertiesConfiguration();
        props.setDelimiterParsingDisabled(true);
        for (int i = 0; i < args.length; i += 2) {
            props.addProperty(args[i], (Object)args[i + 1]);
        }
        return new MockNinjaProperties(mode, contextPath, (Configuration)props);
    }

    public MockNinjaProperties(String mode, String contextPath, Configuration configuration) {
        this.mode = mode;
        this.contextPath = contextPath;
        this.configuration = configuration;
    }

    public String get(String key) {
        return this.configuration.getString(key);
    }

    public String getOrDie(String key) {
        String value = this.get(key);
        if (value == null) {
            throw new IllegalArgumentException("No key with name " + key + " found");
        }
        return value;
    }

    public Integer getInteger(String key) {
        String value = this.get(key);
        if (value == null) {
            return null;
        }
        return Integer.parseInt(value);
    }

    public Integer getIntegerOrDie(String key) {
        String value = this.getOrDie(key);
        if (value == null) {
            return null;
        }
        return Integer.parseInt(value);
    }

    public Boolean getBooleanOrDie(String key) {
        String value = this.getOrDie(key);
        if (value == null) {
            return null;
        }
        return Boolean.parseBoolean(value);
    }

    public Boolean getBoolean(String key) {
        String value = this.get(key);
        if (value == null) {
            return null;
        }
        return Boolean.parseBoolean(value);
    }

    public boolean isDev() {
        return this.mode.equals("dev");
    }

    public boolean isTest() {
        return this.mode.equals("test");
    }

    public boolean isProd() {
        return this.mode.equals("prod");
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public Properties getAllCurrentNinjaProperties() {
        return ConfigurationConverter.getProperties((Configuration)this.configuration);
    }

    public String[] getStringArray(String key) {
        return this.configuration.getStringArray(key);
    }

    public String getWithDefault(String key, String defaultValue) {
        String value = this.get(key);
        if (value == null) {
            return null;
        }
        return defaultValue;
    }

    public Integer getIntegerWithDefault(String key, Integer defaultValue) {
        Integer value = this.getInteger(key);
        if (value == null) {
            return null;
        }
        return defaultValue;
    }

    public Boolean getBooleanWithDefault(String key, Boolean defaultValue) {
        Boolean value = this.getBoolean(key);
        if (value == null) {
            return null;
        }
        return defaultValue;
    }
}

