/*
 * Decompiled with CFR 0.152.
 */
package ninja.servlet;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ninja.Context;
import ninja.Cookie;
import ninja.Result;
import ninja.bodyparser.BodyParserEngineManager;
import ninja.params.ParamParsers;
import ninja.servlet.ResponseStreamsServlet;
import ninja.servlet.ServletCookieHelper;
import ninja.servlet.async.AsyncStrategy;
import ninja.servlet.async.AsyncStrategyFactoryHolder;
import ninja.session.FlashScope;
import ninja.session.Session;
import ninja.uploads.FileItem;
import ninja.uploads.FileItemProvider;
import ninja.uploads.FileProvider;
import ninja.uploads.NoFileItemProvider;
import ninja.utils.AbstractContext;
import ninja.utils.HttpHeaderUtils;
import ninja.utils.NinjaProperties;
import ninja.utils.ResponseStreams;
import ninja.utils.ResultHandler;
import ninja.validation.Validation;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NinjaServletContext
extends AbstractContext {
    private static final Logger logger = LoggerFactory.getLogger(NinjaServletContext.class);
    private final ResultHandler resultHandler;
    private ServletContext servletContext;
    private HttpServletRequest httpServletRequest;
    private HttpServletResponse httpServletResponse;
    private AsyncStrategy asyncStrategy;
    private final Object asyncLock = new Object();
    private boolean formFieldsProcessed = false;
    private Map<String, List<String>> formFieldsMap;
    private Map<String, List<FileItem>> fileFieldsMap;

    @Inject
    public NinjaServletContext(BodyParserEngineManager bodyParserEngineManager, FlashScope flashScope, NinjaProperties ninjaProperties, ResultHandler resultHandler, Session session, Validation validation, Injector injector, ParamParsers paramParsers) {
        super(bodyParserEngineManager, flashScope, ninjaProperties, session, validation, injector, paramParsers);
        this.resultHandler = resultHandler;
    }

    public void init(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.servletContext = servletContext;
        this.httpServletRequest = httpServletRequest;
        this.httpServletResponse = httpServletResponse;
        this.enforceCorrectEncodingOfRequest();
        String contextPath = httpServletRequest.getContextPath();
        String requestPath = this.performGetRequestPath();
        super.init(contextPath, requestPath);
    }

    public String getMethod() {
        return this.httpServletRequest.getMethod();
    }

    @Deprecated
    public String getRequestUri() {
        return this.httpServletRequest.getRequestURI();
    }

    public String getHostname() {
        return this.httpServletRequest.getHeader("host");
    }

    public String getParameter(String key) {
        if (!this.formFieldsProcessed) {
            this.processFormFields();
        }
        if (this.formFieldsMap == null) {
            return this.httpServletRequest.getParameter(key);
        }
        List<String> values = this.formFieldsMap.get(key);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    public List<String> getParameterValues(String name) {
        if (!this.formFieldsProcessed) {
            this.processFormFields();
        }
        if (this.formFieldsMap == null) {
            String[] params = this.httpServletRequest.getParameterValues(name);
            if (params == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(params);
        }
        return this.formFieldsMap.get(name);
    }

    public String getScheme() {
        return this.httpServletRequest.getScheme();
    }

    public String getRealRemoteAddr() {
        return this.httpServletRequest.getRemoteAddr();
    }

    public Object getAttribute(String name) {
        return this.httpServletRequest.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.httpServletRequest.setAttribute(name, value);
    }

    public Map<String, Object> getAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Enumeration en = this.httpServletRequest.getAttributeNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            Object value = this.httpServletRequest.getAttribute(name);
            attributes.put(name, value);
        }
        return attributes;
    }

    public FileItem getParameterAsFileItem(String key) {
        if (!this.formFieldsProcessed) {
            this.processFormFields();
        }
        if (this.fileFieldsMap == null) {
            return null;
        }
        List<FileItem> fileItems = this.fileFieldsMap.get(key);
        if (fileItems == null || fileItems.isEmpty()) {
            return null;
        }
        return fileItems.get(0);
    }

    public List<FileItem> getParameterAsFileItems(String key) {
        if (!this.formFieldsProcessed) {
            this.processFormFields();
        }
        if (this.fileFieldsMap == null) {
            return Collections.emptyList();
        }
        List<FileItem> fileItems = this.fileFieldsMap.get(key);
        if (fileItems == null) {
            return Collections.emptyList();
        }
        return fileItems;
    }

    public Map<String, List<FileItem>> getParameterFileItems() {
        if (!this.formFieldsProcessed) {
            this.processFormFields();
        }
        return this.fileFieldsMap;
    }

    public Map<String, String[]> getParameters() {
        if (!this.formFieldsProcessed) {
            this.processFormFields();
        }
        if (this.formFieldsMap == null) {
            return this.httpServletRequest.getParameterMap();
        }
        String[] type = new String[]{};
        HashMap<String, String[]> map = new HashMap<String, String[]>(this.formFieldsMap.size());
        for (Map.Entry<String, List<String>> entry : this.formFieldsMap.entrySet()) {
            map.put(entry.getKey(), entry.getValue().toArray(type));
        }
        return map;
    }

    public String getHeader(String name) {
        return this.httpServletRequest.getHeader(name);
    }

    public List<String> getHeaders(String name) {
        return Collections.list(this.httpServletRequest.getHeaders(name));
    }

    public Map<String, List<String>> getHeaders() {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        Enumeration names = this.httpServletRequest.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            headers.put(name, Collections.list(this.httpServletRequest.getHeaders(name)));
        }
        return headers;
    }

    public Cookie getCookie(String cookieName) {
        javax.servlet.http.Cookie[] cookies = this.httpServletRequest.getCookies();
        if (cookies == null) {
            return null;
        }
        javax.servlet.http.Cookie servletCookie = ServletCookieHelper.getCookie(cookieName, cookies);
        if (servletCookie == null) {
            return null;
        }
        return ServletCookieHelper.convertServletCookieToNinjaCookie(servletCookie);
    }

    public boolean hasCookie(String cookieName) {
        return ServletCookieHelper.getCookie(cookieName, this.httpServletRequest.getCookies()) != null;
    }

    public List<Cookie> getCookies() {
        javax.servlet.http.Cookie[] servletCookies = this.httpServletRequest.getCookies();
        if (servletCookies == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Cookie> ninjaCookies = new ArrayList<Cookie>(servletCookies.length);
        for (javax.servlet.http.Cookie cookie : servletCookies) {
            Cookie ninjaCookie = ServletCookieHelper.convertServletCookieToNinjaCookie(cookie);
            ninjaCookies.add(ninjaCookie);
        }
        return ninjaCookies;
    }

    public void addCookie(Cookie cookie) {
        this.httpServletResponse.addCookie(ServletCookieHelper.convertNinjaCookieToServletCookie(cookie));
    }

    public boolean isAsync() {
        return this.asyncStrategy != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnResultAsync(Result result) {
        Object object = this.asyncLock;
        synchronized (object) {
            this.handleAsync();
            this.asyncStrategy.returnResultAsync(result, (Context)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAsync() {
        Object object = this.asyncLock;
        synchronized (object) {
            if (this.asyncStrategy == null) {
                this.asyncStrategy = AsyncStrategyFactoryHolder.getInstance(this.httpServletRequest).createStrategy(this.httpServletRequest, this.resultHandler);
                this.asyncStrategy.handleAsync();
            }
        }
    }

    public Result controllerReturned() {
        if (this.asyncStrategy != null) {
            return this.asyncStrategy.controllerReturned();
        }
        return null;
    }

    public InputStream getInputStream() throws IOException {
        return this.httpServletRequest.getInputStream();
    }

    public BufferedReader getReader() throws IOException {
        return this.httpServletRequest.getReader();
    }

    protected ResponseStreams finalizeHeaders(Result result, Boolean handleFlashAndSessionCookie) {
        super.finalizeHeaders(result, handleFlashAndSessionCookie);
        this.httpServletResponse.setStatus(result.getStatusCode());
        for (Map.Entry header : result.getHeaders().entrySet()) {
            this.httpServletResponse.addHeader((String)header.getKey(), (String)header.getValue());
        }
        if (result.getContentType() != null) {
            this.httpServletResponse.setContentType(result.getContentType());
        }
        if (result.getCharset() != null) {
            this.httpServletResponse.setCharacterEncoding(result.getCharset());
        } else {
            this.httpServletResponse.setCharacterEncoding("utf-8");
        }
        ResponseStreamsServlet responseStreamsServlet = new ResponseStreamsServlet();
        responseStreamsServlet.init(this.httpServletResponse);
        return responseStreamsServlet;
    }

    public String getRequestContentType() {
        return this.httpServletRequest.getContentType();
    }

    public boolean isMultipart() {
        return ServletFileUpload.isMultipartContent((HttpServletRequest)this.httpServletRequest);
    }

    public FileItemIterator getFileItemIterator() {
        long maxFileSize = this.ninjaProperties.getIntegerWithDefault("uploads.max_file_size", Integer.valueOf(-1)).intValue();
        long maxTotalSize = this.ninjaProperties.getIntegerWithDefault("uploads.max_total_size", Integer.valueOf(-1)).intValue();
        ServletFileUpload upload = new ServletFileUpload();
        upload.setFileSizeMax(maxFileSize);
        upload.setSizeMax(maxTotalSize);
        FileItemIterator fileItemIterator = null;
        try {
            fileItemIterator = upload.getItemIterator(this.httpServletRequest);
        }
        catch (IOException | FileUploadException e) {
            logger.error("Error while trying to process mulitpart file upload", e);
        }
        return fileItemIterator;
    }

    private String performGetRequestPath() {
        String unencodedContextPath = this.httpServletRequest.getContextPath();
        String fullUnencodedUri = this.httpServletRequest.getRequestURI();
        String result = fullUnencodedUri.substring(unencodedContextPath.length());
        return result;
    }

    private void enforceCorrectEncodingOfRequest() {
        String charset = "utf-8";
        String contentType = this.getHeader("Content-Type");
        if (contentType != null) {
            charset = HttpHeaderUtils.getCharsetOfContentTypeOrUtf8((String)contentType);
        }
        try {
            this.httpServletRequest.setCharacterEncoding(charset);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Server does not support charset of content type: " + contentType);
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.httpServletResponse;
    }

    private void processFormFields() {
        if (this.formFieldsProcessed) {
            return;
        }
        this.formFieldsProcessed = true;
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)this.httpServletRequest)) {
            return;
        }
        FileProvider fileProvider = null;
        if (this.route != null) {
            if (fileProvider == null) {
                fileProvider = this.route.getControllerMethod().getAnnotation(FileProvider.class);
            }
            if (fileProvider == null) {
                fileProvider = this.route.getControllerClass().getAnnotation(FileProvider.class);
            }
        }
        FileItemProvider fileItemProvider = null;
        fileItemProvider = fileProvider == null ? (FileItemProvider)this.injector.getInstance(FileItemProvider.class) : (FileItemProvider)this.injector.getInstance(fileProvider.value());
        if (fileItemProvider instanceof NoFileItemProvider) {
            return;
        }
        ArrayListMultimap formMap = ArrayListMultimap.create();
        ArrayListMultimap fileMap = ArrayListMultimap.create();
        try {
            FileItemIterator fileItemIterator = this.getFileItemIterator();
            while (fileItemIterator.hasNext()) {
                FileItemStream item = fileItemIterator.next();
                if (item.isFormField()) {
                    String charset = "utf-8";
                    String contentType = item.getContentType();
                    if (contentType != null) {
                        charset = HttpHeaderUtils.getCharsetOfContentTypeOrUtf8((String)contentType);
                    }
                    String value = Streams.asString((InputStream)item.openStream(), (String)charset);
                    formMap.put((Object)item.getFieldName(), (Object)value);
                    continue;
                }
                FileItem fileItem = fileItemProvider.create(item);
                fileMap.put((Object)item.getFieldName(), (Object)fileItem);
            }
        }
        catch (IOException | FileUploadException e) {
            throw new RuntimeException("Failed to parse multipart request data", e);
        }
        this.formFieldsMap = this.toUnmodifiableMap((Multimap)formMap);
        this.fileFieldsMap = this.toUnmodifiableMap((Multimap)fileMap);
    }

    private <T> Map<String, List<T>> toUnmodifiableMap(Multimap<String, T> multimap) {
        HashMap map = new HashMap(multimap.size());
        for (Map.Entry entry : multimap.asMap().entrySet()) {
            Collection value = (Collection)entry.getValue();
            if (value == null) {
                Collections.emptyList();
                continue;
            }
            if (value instanceof List) {
                map.put(entry.getKey(), (List)value);
                continue;
            }
            map.put(entry.getKey(), new ArrayList(value));
        }
        return Collections.unmodifiableMap(map);
    }

    public void cleanup() {
        if (this.fileFieldsMap != null) {
            for (List<FileItem> files : this.fileFieldsMap.values()) {
                for (FileItem file : files) {
                    file.cleanup();
                }
            }
        }
    }
}

