/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.commit;

import java.io.File;
import java.io.IOException;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.commit.CommitInformation;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;

public class CommitBuilder
implements Builder {
    public static final String UNKNOWN = "commit: nothing known about `";
    public static final String EXAM_DIR = ": Examining";
    public static final String REMOVING = "Removing ";
    public static final String NEW_REVISION = "new revision:";
    public static final String INITIAL_REVISION = "initial revision:";
    public static final String DELETED_REVISION = "delete";
    public static final String DONE = "done";
    public static final String RCS_FILE = "RCS file: ";
    public static final String ADD = "commit: use `cvs add' to create an entry for ";
    public static final String COMMITTED = " <-- ";
    private CommitInformation commitInformation;
    private File fileDirectory;
    private final EventManager eventManager;
    private final String localPath;
    private final String repositoryRoot;
    private boolean isAdding;

    public CommitBuilder(EventManager eventManager, String string, String string2) {
        this.eventManager = eventManager;
        this.localPath = string;
        this.repositoryRoot = string2;
    }

    public void outputDone() {
        if (this.commitInformation != null) {
            this.eventManager.fireCVSEvent(new FileInfoEvent(this, this.commitInformation));
            this.commitInformation = null;
        }
    }

    public void parseLine(String string, boolean bl) {
        if (string.indexOf(UNKNOWN) >= 0) {
            this.outputDone();
            this.processUnknownFile(string.substring(string.indexOf(UNKNOWN) + UNKNOWN.length()).trim());
        } else if (string.indexOf(ADD) > 0) {
            this.processToAddFile(string.substring(string.indexOf(ADD) + ADD.length()).trim());
        } else {
            int n = string.indexOf(COMMITTED);
            if (n > 0) {
                File file;
                this.outputDone();
                String string2 = string.substring(n + COMMITTED.length()).trim();
                if (this.fileDirectory == null) {
                    String string3 = string.substring(0, n).trim();
                    if (string3.startsWith(this.repositoryRoot) && (string3 = string3.substring(this.repositoryRoot.length())).startsWith("/")) {
                        string3 = string3.substring(1);
                    }
                    if ((n = string3.lastIndexOf(47)) > 0) {
                        string3 = string3.substring(0, n);
                    }
                    file = this.findFile(string2, string3);
                } else {
                    file = new File(this.fileDirectory, string2);
                }
                this.processFile(file);
                if (this.isAdding) {
                    this.commitInformation.setType("Added");
                    this.isAdding = false;
                } else {
                    this.commitInformation.setType("Changed");
                }
            } else if (string.startsWith(REMOVING)) {
                this.outputDone();
                this.processFile(string.substring(REMOVING.length(), string.length() - 1));
                this.commitInformation.setType("Removed");
            } else if (string.indexOf(EXAM_DIR) >= 0) {
                this.fileDirectory = new File(this.localPath, string.substring(string.indexOf(EXAM_DIR) + EXAM_DIR.length()).trim());
            } else if (string.startsWith(RCS_FILE)) {
                this.isAdding = true;
            } else if (string.startsWith(DONE)) {
                this.outputDone();
            } else if (string.startsWith(INITIAL_REVISION)) {
                this.processRevision(string.substring(INITIAL_REVISION.length()));
                this.commitInformation.setType("Added");
            } else if (string.startsWith(NEW_REVISION)) {
                this.processRevision(string.substring(NEW_REVISION.length()));
            }
        }
    }

    private File createFile(String string) {
        return new File(this.localPath, string);
    }

    private void processUnknownFile(String string) {
        this.commitInformation = new CommitInformation();
        this.commitInformation.setType("Unknown");
        int n = string.indexOf(39);
        String string2 = string.substring(0, n).trim();
        this.commitInformation.setFile(this.createFile(string2));
        this.outputDone();
    }

    private void processToAddFile(String string) {
        this.commitInformation = new CommitInformation();
        this.commitInformation.setType("To-be-added");
        String string2 = string.trim();
        if (string2.endsWith(";")) {
            string2 = string2.substring(0, string2.length() - 2);
        }
        this.commitInformation.setFile(this.createFile(string2));
        this.outputDone();
    }

    private void processFile(String string) {
        if (this.commitInformation == null) {
            this.commitInformation = new CommitInformation();
        }
        if (string.startsWith("no file")) {
            string = string.substring(8);
        }
        this.commitInformation.setFile(this.createFile(string));
    }

    private void processFile(File file) {
        if (this.commitInformation == null) {
            this.commitInformation = new CommitInformation();
        }
        this.commitInformation.setFile(file);
    }

    private void processRevision(String string) {
        int n = string.indexOf(59);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        if (DELETED_REVISION.equals(string = string.trim())) {
            this.commitInformation.setType("Removed");
        }
        this.commitInformation.setRevision(string);
    }

    public void parseEnhancedMessage(String string, Object object) {
    }

    private File findFile(String string, String string2) {
        File file;
        File file2 = new File(this.localPath);
        if (string2.endsWith("/Attic")) {
            string2 = string2.substring(0, string2.length() - 6);
        }
        if ((file = this.quickFindFile(file2, string, string2)) != null) {
            return file;
        }
        return this.findFile(file2, string, string2);
    }

    private File findFile(File file, String string, String string2) {
        if (this.isWorkForRepository(file, string2)) {
            return new File(file, string);
        }
        File file2 = null;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; !(i >= fileArray.length || fileArray[i].isDirectory() && (file2 = this.findFile(fileArray[i], string, string2)) != null); ++i) {
            }
        }
        return file2;
    }

    private File quickFindFile(File file, String string, String string2) {
        do {
            File file2;
            if (!this.isWorkForRepository(file2 = new File(file, string2), string2)) continue;
            return new File(file2, string);
        } while ((file = file.getParentFile()) != null);
        return null;
    }

    private boolean isWorkForRepository(File file, String string) {
        try {
            String string2 = this.eventManager.getClientServices().getRepositoryForDirectory(file);
            String string3 = this.eventManager.getClientServices().getRepository();
            if (string2.startsWith(string3)) {
                string2 = string2.substring(string3.length() + 1);
            }
            return string.equals(string2);
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

