/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.driver;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.ogm.driver.ParameterConversion;
import org.neo4j.ogm.driver.TypeSystem;

class TypeSystemBasedParameterConversion
implements ParameterConversion {
    private final ParameterConversion fallback = ParameterConversion.DefaultParameterConversion.INSTANCE;
    private final TypeSystem typeSystem;

    TypeSystemBasedParameterConversion(TypeSystem typeSystem) {
        this.typeSystem = typeSystem;
    }

    @Override
    public Map<String, Object> convertParameters(Map<String, Object> originalParameter) {
        HashMap<String, Object> convertedParameter = new HashMap<String, Object>(originalParameter.size());
        HashMap<String, Object> unconvertedParameter = new HashMap<String, Object>(originalParameter.size());
        originalParameter.forEach((parameterKey, unconvertedValue) -> {
            if (unconvertedValue == null) {
                convertedParameter.put((String)parameterKey, null);
            } else if (unconvertedValue instanceof List) {
                convertedParameter.put((String)parameterKey, this.convertListItems((List)unconvertedValue));
            } else if (unconvertedValue.getClass().isArray()) {
                convertedParameter.put((String)parameterKey, this.convertArrayItems(unconvertedValue));
            } else if (unconvertedValue instanceof Map) {
                convertedParameter.put((String)parameterKey, this.convertParameters((Map)unconvertedValue));
            } else if (this.typeSystem.supportsAsNativeType(unconvertedValue.getClass())) {
                Object convertedValue = this.typeSystem.getMappedToNativeTypeAdapter(unconvertedValue.getClass()).apply(unconvertedValue);
                convertedParameter.put((String)parameterKey, convertedValue);
            } else {
                unconvertedParameter.put((String)parameterKey, unconvertedValue);
            }
        });
        convertedParameter.putAll(this.fallback.convertParameters(unconvertedParameter));
        return convertedParameter;
    }

    private List<?> convertListItems(List<?> unconvertedValues) {
        return unconvertedValues.stream().map(this::convertSingle).collect(Collectors.toList());
    }

    private Object[] convertArrayItems(Object unconvertedValues) {
        int length = Array.getLength(unconvertedValues);
        Object[] convertedValues = new Object[length];
        for (int i = 0; i < length; ++i) {
            convertedValues[i] = this.convertSingle(Array.get(unconvertedValues, i));
        }
        return convertedValues;
    }

    private Object convertSingle(Object value) {
        if (this.typeSystem.supportsAsNativeType(value.getClass())) {
            return this.typeSystem.getMappedToNativeTypeAdapter(value.getClass()).apply(value);
        }
        String fixedKey = "u";
        return this.convertParameters(Collections.singletonMap(fixedKey, value)).get(fixedKey);
    }
}

