/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.util.scheduler;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class MariaDbThreadFactory
implements ThreadFactory {
    private final ThreadFactory parentFactory = Executors.defaultThreadFactory();
    private final AtomicInteger threadId = new AtomicInteger();
    private final String poolName;

    public MariaDbThreadFactory(String poolName) {
        this.poolName = poolName;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread result = this.parentFactory.newThread(runnable);
        result.setName("MariaDb-" + this.poolName + "-" + this.threadId.incrementAndGet());
        result.setDaemon(true);
        return result;
    }
}

