/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.processor;

import java.io.IOException;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;
import org.mapstruct.ap.internal.model.GeneratedType;
import org.mapstruct.ap.internal.model.Mapper;
import org.mapstruct.ap.internal.processor.ModelElementProcessor;
import org.mapstruct.ap.internal.writer.ModelWriter;

public class MapperRenderingProcessor
implements ModelElementProcessor<Mapper, Mapper> {
    @Override
    public Mapper process(ModelElementProcessor.ProcessorContext context, TypeElement mapperTypeElement, Mapper mapper) {
        if (!context.isErroneous()) {
            this.writeToSourceFile(context.getFiler(), mapper);
            return mapper;
        }
        return null;
    }

    private void writeToSourceFile(Filer filer, Mapper model) {
        ModelWriter modelWriter = new ModelWriter();
        this.createSourceFile(model, modelWriter, filer);
        if (model.getDecorator() != null) {
            this.createSourceFile(model.getDecorator(), modelWriter, filer);
        }
    }

    private void createSourceFile(GeneratedType model, ModelWriter modelWriter, Filer filer) {
        JavaFileObject sourceFile;
        String fileName = "";
        if (model.hasPackageName()) {
            fileName = fileName + model.getPackageName() + ".";
        }
        fileName = fileName + model.getName();
        try {
            sourceFile = filer.createSourceFile(fileName, new Element[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        modelWriter.writeModel(sourceFile, model);
    }

    @Override
    public int getPriority() {
        return 9999;
    }
}

