/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.reflection.runtime.reflect.opt;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.jaxb.reflection.bytecode.ClassTailor;
import org.jvnet.jaxb.reflection.impl.Util;
import org.jvnet.jaxb.reflection.model.core.TypeInfo;
import org.jvnet.jaxb.reflection.model.runtime.RuntimeClassInfo;
import org.jvnet.jaxb.reflection.model.runtime.RuntimePropertyInfo;
import org.jvnet.jaxb.reflection.runtime.reflect.Accessor;
import org.jvnet.jaxb.reflection.runtime.reflect.TransducedAccessor;
import org.jvnet.jaxb.reflection.runtime.reflect.opt.AccessorInjector;
import org.jvnet.jaxb.reflection.runtime.reflect.opt.Bean;
import org.jvnet.jaxb.reflection.runtime.reflect.opt.TransducedAccessor_field_Byte;
import org.jvnet.jaxb.reflection.runtime.reflect.opt.TransducedAccessor_method_Byte;

public abstract class OptimizedTransducedAccessorFactory {
    private static final Logger logger = Util.getClassLogger();
    private static final String fieldTemplateName;
    private static final String methodTemplateName;
    private static final Map<Class, String> suffixMap;

    private OptimizedTransducedAccessorFactory() {
    }

    public static final TransducedAccessor get(RuntimePropertyInfo runtimePropertyInfo) {
        AnnotatedElement annotatedElement;
        Accessor accessor;
        Accessor accessor2 = runtimePropertyInfo.getAccessor();
        Class<?> clazz = null;
        TypeInfo typeInfo = runtimePropertyInfo.parent();
        if (!(typeInfo instanceof RuntimeClassInfo)) {
            return null;
        }
        Class clazz2 = (Class)((RuntimeClassInfo)typeInfo).getClazz();
        String string = ClassTailor.toVMClassName(clazz2) + "_JaxbXducedAccessor_" + runtimePropertyInfo.getName();
        if (accessor2 instanceof Accessor.FieldReflection) {
            accessor = (Accessor.FieldReflection)accessor2;
            annotatedElement = accessor.f;
            int n = ((Field)annotatedElement).getModifiers();
            if (Modifier.isPrivate(n) || Modifier.isFinal(n)) {
                return null;
            }
            Class<?> clazz3 = ((Field)annotatedElement).getType();
            if (clazz3.isPrimitive()) {
                clazz = AccessorInjector.prepare(clazz2, fieldTemplateName + suffixMap.get(clazz3), string, ClassTailor.toVMClassName(Bean.class), ClassTailor.toVMClassName(clazz2), "f_" + clazz3.getName(), ((Field)annotatedElement).getName());
            }
        }
        if (accessor2.getClass() == Accessor.GetterSetterReflection.class) {
            accessor = (Accessor.GetterSetterReflection)accessor2;
            if (((Accessor.GetterSetterReflection)accessor).getter == null || ((Accessor.GetterSetterReflection)accessor).setter == null) {
                return null;
            }
            annotatedElement = ((Accessor.GetterSetterReflection)accessor).getter.getReturnType();
            if (Modifier.isPrivate(((Accessor.GetterSetterReflection)accessor).getter.getModifiers()) || Modifier.isPrivate(((Accessor.GetterSetterReflection)accessor).setter.getModifiers())) {
                return null;
            }
            if (((Class)annotatedElement).isPrimitive()) {
                clazz = AccessorInjector.prepare(clazz2, methodTemplateName + suffixMap.get(annotatedElement), string, ClassTailor.toVMClassName(Bean.class), ClassTailor.toVMClassName(clazz2), "get_" + ((Class)annotatedElement).getName(), ((Accessor.GetterSetterReflection)accessor).getter.getName(), "set_" + ((Class)annotatedElement).getName(), ((Accessor.GetterSetterReflection)accessor).setter.getName());
            }
        }
        if (clazz == null) {
            return null;
        }
        logger.log(Level.FINE, "Using optimized TransducedAccessor for " + runtimePropertyInfo.displayName());
        try {
            return (TransducedAccessor)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            logger.log(Level.INFO, "failed to load an optimized TransducedAccessor", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.log(Level.INFO, "failed to load an optimized TransducedAccessor", illegalAccessException);
        }
        catch (SecurityException securityException) {
            logger.log(Level.INFO, "failed to load an optimized TransducedAccessor", securityException);
        }
        return null;
    }

    static {
        String string = TransducedAccessor_field_Byte.class.getName();
        fieldTemplateName = string.substring(0, string.length() - "Byte".length()).replace('.', '/');
        string = TransducedAccessor_method_Byte.class.getName();
        methodTemplateName = string.substring(0, string.length() - "Byte".length()).replace('.', '/');
        suffixMap = new HashMap<Class, String>();
        suffixMap.put(Byte.TYPE, "Byte");
        suffixMap.put(Short.TYPE, "Short");
        suffixMap.put(Integer.TYPE, "Integer");
        suffixMap.put(Long.TYPE, "Long");
        suffixMap.put(Boolean.TYPE, "Boolean");
        suffixMap.put(Float.TYPE, "Float");
        suffixMap.put(Double.TYPE, "Double");
    }
}

