/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.reflection.runtime.property;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.DomHandler;
import javax.xml.stream.XMLStreamException;
import org.jvnet.jaxb.reflection.ClassFactory;
import org.jvnet.jaxb.reflection.impl.api.AccessorException;
import org.jvnet.jaxb.reflection.model.core.PropertyKind;
import org.jvnet.jaxb.reflection.model.core.WildcardMode;
import org.jvnet.jaxb.reflection.model.runtime.RuntimeElement;
import org.jvnet.jaxb.reflection.model.runtime.RuntimeReferencePropertyInfo;
import org.jvnet.jaxb.reflection.runtime.ElementBeanInfoImpl;
import org.jvnet.jaxb.reflection.runtime.JAXBContextImpl;
import org.jvnet.jaxb.reflection.runtime.JaxBeanInfo;
import org.jvnet.jaxb.reflection.runtime.XMLSerializer;
import org.jvnet.jaxb.reflection.runtime.property.PropertyImpl;
import org.jvnet.jaxb.reflection.runtime.property.UnmarshallerChain;
import org.jvnet.jaxb.reflection.runtime.reflect.Accessor;
import org.jvnet.jaxb.reflection.runtime.unmarshaller.ChildLoader;
import org.jvnet.jaxb.reflection.runtime.unmarshaller.WildcardLoader;
import org.jvnet.jaxb.reflection.util.QNameMap;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SingleReferenceNodeProperty<BeanT, ValueT>
extends PropertyImpl<BeanT> {
    private final Accessor<BeanT, ValueT> acc;
    private final QNameMap<JaxBeanInfo> expectedElements = new QNameMap();
    private final DomHandler domHandler;
    private final WildcardMode wcMode;

    public SingleReferenceNodeProperty(JAXBContextImpl jAXBContextImpl, RuntimeReferencePropertyInfo runtimeReferencePropertyInfo) {
        super(jAXBContextImpl, runtimeReferencePropertyInfo);
        this.acc = runtimeReferencePropertyInfo.getAccessor().optimize(jAXBContextImpl);
        for (RuntimeElement runtimeElement : runtimeReferencePropertyInfo.getElements()) {
            this.expectedElements.put(runtimeElement.getElementName(), jAXBContextImpl.getOrCreate(runtimeElement));
        }
        if (runtimeReferencePropertyInfo.getWildcard() != null) {
            this.domHandler = (DomHandler)ClassFactory.create((Class)runtimeReferencePropertyInfo.getDOMHandler());
            this.wcMode = runtimeReferencePropertyInfo.getWildcard();
        } else {
            this.domHandler = null;
            this.wcMode = null;
        }
    }

    @Override
    public void reset(BeanT BeanT) throws AccessorException {
        this.acc.set(BeanT, null);
    }

    @Override
    public String getIdValue(BeanT BeanT) {
        return null;
    }

    @Override
    public void serializeBody(BeanT BeanT, XMLSerializer xMLSerializer, Object object) throws SAXException, AccessorException, IOException, XMLStreamException {
        ValueT ValueT = this.acc.get(BeanT);
        if (ValueT != null) {
            try {
                JaxBeanInfo jaxBeanInfo = xMLSerializer.grammar.getBeanInfo(ValueT, true);
                if (jaxBeanInfo.jaxbType == Object.class && this.domHandler != null) {
                    xMLSerializer.writeDom(ValueT, this.domHandler, BeanT, this.fieldName);
                } else {
                    jaxBeanInfo.serializeRoot(ValueT, xMLSerializer);
                }
            }
            catch (JAXBException jAXBException) {
                xMLSerializer.reportError(this.fieldName, jAXBException);
            }
        }
    }

    @Override
    public void buildChildElementUnmarshallers(UnmarshallerChain unmarshallerChain, QNameMap<ChildLoader> qNameMap) {
        for (QNameMap.Entry<JaxBeanInfo> entry : this.expectedElements.entrySet()) {
            qNameMap.put(entry.nsUri, entry.localName, new ChildLoader(entry.getValue().getLoader(unmarshallerChain.context, true), this.acc));
        }
        if (this.domHandler != null) {
            qNameMap.put(CATCH_ALL, new ChildLoader(new WildcardLoader(this.domHandler, this.wcMode), this.acc));
        }
    }

    @Override
    public PropertyKind getKind() {
        return PropertyKind.REFERENCE;
    }

    @Override
    public Accessor getElementPropertyAccessor(String string, String string2) {
        JaxBeanInfo jaxBeanInfo = this.expectedElements.get(string, string2);
        if (jaxBeanInfo != null) {
            if (jaxBeanInfo instanceof ElementBeanInfoImpl) {
                final ElementBeanInfoImpl elementBeanInfoImpl = (ElementBeanInfoImpl)jaxBeanInfo;
                return new Accessor<BeanT, Object>(elementBeanInfoImpl.expectedType){

                    @Override
                    public Object get(BeanT BeanT) throws AccessorException {
                        Object ValueT = SingleReferenceNodeProperty.this.acc.get(BeanT);
                        if (ValueT instanceof JAXBElement) {
                            return ((JAXBElement)ValueT).getValue();
                        }
                        return ValueT;
                    }

                    @Override
                    public void set(BeanT BeanT, Object object) throws AccessorException {
                        if (object != null) {
                            try {
                                object = elementBeanInfoImpl.createInstanceFromValue(object);
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                throw new AccessorException(illegalAccessException);
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                throw new AccessorException(invocationTargetException);
                            }
                            catch (InstantiationException instantiationException) {
                                throw new AccessorException(instantiationException);
                            }
                        }
                        SingleReferenceNodeProperty.this.acc.set(BeanT, object);
                    }
                };
            }
            return this.acc;
        }
        return null;
    }
}

